/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.validate.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetailControlInfo;
import kd.tmc.fpm.business.domain.model.control.DetailControlInfo;
import kd.tmc.fpm.business.domain.model.control.ValidateResult;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.match.MatchResult;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.match.validate.impl.AbstractMatchValidator;
import kd.tmc.fpm.business.mvc.service.match.validate.impl.MatchResultCheckValidator;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class MatchResultDetailControlValidator
extends MatchResultCheckValidator {
    private ControlStrategyDetailControlInfo controlStrategyDetailControlInfo;

    public MatchResultDetailControlValidator(ControlContext controlContext) {
        super(controlContext);
        this.controlStrategyDetailControlInfo = controlContext.getControlStrategyDetailControlInfo();
    }

    public MatchResultDetailControlValidator(AbstractMatchValidator abstractMatchValidator) {
        super(abstractMatchValidator);
        this.controlStrategyDetailControlInfo = this.controlContext.getControlStrategyDetailControlInfo();
    }

    @Override
    ValidateResult doContinueValidate(ValidateResult validateResult) {
        ControlStrategy controlStrategy;
        DetailControlInfo detailControlInfo;
        if (!this.controlContext.isCheckDetailControl() && !this.controlContext.getPlanExecuteOpType().isOccupy()) {
            return validateResult;
        }
        MatchResult matchResult = validateResult.getMatchResult();
        ReportData reportData = matchResult.getReportData();
        Long reportOrgId = 0L;
        Long subjectId = 0L;
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dataDimValList = reportData.getDimValList();
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = dimList.get(i);
            if (templateDim.getDimType().isOrgDim()) {
                reportOrgId = (Long)dataDimValList.get(i);
            }
            if (templateDim.getDimType().isSubjectDim()) {
                subjectId = (Long)dataDimValList.get(i);
            }
            if (EmptyUtil.isNoEmpty((Long)reportOrgId) && EmptyUtil.isNoEmpty((Long)subjectId)) break;
        }
        if (EmptyUtil.isEmpty((Object)(detailControlInfo = this.controlStrategyDetailControlInfo.getDetailControlInfo(controlStrategy = this.controlContext.getControlStrategy(matchResult.getMatchRule().getSystemId(), matchResult.getReportTypeId(), reportOrgId))))) {
            return validateResult;
        }
        this.doCheck(detailControlInfo, validateResult, subjectId);
        return validateResult;
    }

    private void doCheck(DetailControlInfo detailControlInfo, ValidateResult validateResult, Long subjectId) {
        Set<Long> detailDimIds;
        MatchResult matchResult = validateResult.getMatchResult();
        Set<Long> optionalDims = detailControlInfo.getOptionalDimIds(subjectId);
        Long systemId = matchResult.getMatchRule().getSystemId();
        FundPlanSystem system = this.controlContext.getSystem(systemId);
        if (EmptyUtil.isNoEmpty(optionalDims)) {
            HashSet<Long> opDims = new HashSet<Long>(optionalDims);
            DimensionInfoBean dimensionInfoBean = matchResult.getDimensionInfoBean();
            List dimensionIdList = dimensionInfoBean.getDimensionIdList();
            Supplier<String> errorMsg = () -> {
                String optionalDimName = system.getMainDimList().stream().filter(dim -> opDims.contains(dim.getId())).map(Dimension::getName).collect(Collectors.joining(","));
                ControlStrategy controlStrategy = detailControlInfo.getControlStrategy();
                return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u3010%1$s\u3011\u4f53\u7cfb\u3010%2$s\u3011\u63a7\u5236\u7b56\u7565\u3010%3$s\u3011\u5339\u914d\u5230\u7684\u79d1\u76ee\u4e3a\u6309\u660e\u7ec6\u9879\u63a7\uff0c\u4f46\u5339\u914d\u4e0d\u5230\u53ef\u9009\u7ef4\u5ea6\u3010%4$s\u3011", (String)"MatchInfoReportDataSelectorControlExecuteStrategy_0", (String)"tmc-fpm-business", (Object[])new Object[0]), matchResult.getBillBizInfo().getBillNo(), system.getName(), controlStrategy.getName(), optionalDimName);
            };
            if (dimensionIdList.size() <= 4) {
                validateResult.setMatchException(new MatchException(errorMsg.get(), MatchException.MatchErrorType.MATCH_OTIONAL_CONTROL));
                return;
            }
            dimensionIdList.subList(4, dimensionIdList.size()).forEach(opDims::remove);
            if (EmptyUtil.isNoEmpty(opDims)) {
                validateResult.setMatchException(new MatchException(errorMsg.get(), MatchException.MatchErrorType.MATCH_OTIONAL_CONTROL));
                return;
            }
        }
        if (EmptyUtil.isEmpty(detailDimIds = detailControlInfo.getDetailDimIds(subjectId))) {
            return;
        }
        Supplier<String> errorMsg = () -> {
            String optionalDimName = system.getDetailDimList().stream().filter(dim -> detailDimIds.contains(dim.getId())).map(Dimension::getName).collect(Collectors.joining(","));
            ControlStrategy controlStrategy = detailControlInfo.getControlStrategy();
            return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u3010%1$s\u3011\u4f53\u7cfb\u3010%2$s\u3011\u63a7\u5236\u7b56\u7565\u3010%3$s\u3011\u5339\u914d\u5230\u7684\u79d1\u76ee\u4e3a\u6309\u660e\u7ec6\u9879\u63a7\uff0c\u4f46\u5339\u914d\u4e0d\u4e0a\u6240\u6709\u6309\u660e\u7ec6\u9879\u63a7\u7684\u660e\u7ec6\u7ef4\u5ea6\u3010%4$s\u3011", (String)"MatchInfoReportDataSelectorControlExecuteStrategy_1", (String)"tmc-fpm-business", (Object[])new Object[0]), matchResult.getBillBizInfo().getBillNo(), system.getName(), controlStrategy.getName(), optionalDimName);
        };
        if (!matchResult.isMatchedDetail()) {
            validateResult.setMatchException(new MatchException(errorMsg.get(), MatchException.MatchErrorType.MATCH_DETAIL_CONTROL));
            return;
        }
        BitMap<Long, Long> detailDimBitMap = matchResult.getMatchedDetailDim();
        List<Long> list = detailDimBitMap.findList(detailDimIds);
        if (EmptyUtil.isEmpty(list)) {
            validateResult.setMatchException(new MatchException(errorMsg.get(), MatchException.MatchErrorType.MATCH_DETAIL_CONTROL));
        }
    }
}

