/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.match.validate.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.control.ValidateResult;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.match.MatchResult;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.match.validate.impl.MatchResultCheckValidator;

public class MatchResultMatchRuleDimValidator
extends MatchResultCheckValidator {
    public MatchResultMatchRuleDimValidator(ControlContext controlContext) {
        super(controlContext);
    }

    @Override
    ValidateResult doContinueValidate(ValidateResult validateResult) {
        MatchResult matchResult = validateResult.getMatchResult();
        BillMatchRule matchRule = matchResult.getMatchRule();
        Set matchRuleAllDimIds = matchRule.getMappings().stream().map(MatchMapping::getDimId).collect(Collectors.toSet());
        List<ReportData> reportDataList = matchResult.getMatchedReportDataList();
        for (ReportData reportData : reportDataList) {
            Set newAddDimIds = reportData.getDimList().stream().map(TemplateDim::getDimensionId).filter(id -> !matchRuleAllDimIds.contains(id)).collect(Collectors.toSet());
            if (EmptyUtil.isEmpty(newAddDimIds)) continue;
            Long systemId = matchRule.getSystemId();
            FundPlanSystem system = this.controlContext.getSystem(systemId);
            String dimNames = newAddDimIds.stream().map(system::getMainDimensionByDimensionId).map(Dimension::getName).collect(Collectors.joining(","));
            String errMsg = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u3010%2$s\u3011\u8ba1\u5212\u7f16\u5236\u5355\u636e\u7684\u7ef4\u5ea6\u591a\u4e8e\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u7684\u7ef4\u5ea6\u3010%3$s\u3011\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"NewMatchInfoBackFillControlExecuteStrategy_2", (String)"tmc-fpm-business", (Object[])new Object[0]), system.getName(), matchRule.getNumber(), dimNames);
            validateResult.setMatchException(new MatchException(errMsg, MatchException.MatchErrorType.MATCH_MATCH_RULE));
            return validateResult;
        }
        return validateResult;
    }
}

