/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateMessage;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateResultInfo;

public class ReportGenerateResult {
    private final Map<Long, ReportGenerateResultInfo> reportGenerateResultInfoMap = new HashMap<Long, ReportGenerateResultInfo>(16);
    private final Map<Long, ReportTemplate> reportTemplateMap;
    private final ReportGenerateMessage reportGenerateMessage = new ReportGenerateMessage();
    private final List<Long> saveSuccessReportIds;
    private String errorMsg;
    private int count = 0;

    public ReportGenerateResult() {
        this.reportTemplateMap = new HashMap<Long, ReportTemplate>(16);
        this.saveSuccessReportIds = new ArrayList<Long>(16);
    }

    public void addTemplate(ReportTemplate template) {
        this.reportGenerateResultInfoMap.computeIfAbsent(template.getId(), k -> new ReportGenerateResultInfo(template));
        this.reportTemplateMap.put(template.getCopyId(), template);
    }

    public void addReport(Report report) {
        ReportTemplate template = report.getTemplate();
        ReportGenerateResultInfo reportGenerateResultInfo = this.reportGenerateResultInfoMap.get(template.getId());
        if (reportGenerateResultInfo == null) {
            throw new KDBizException("templateId:" + template.getId() + " templateNumber:" + template.getNumber() + "is not registered");
        }
        ++this.count;
    }

    public List<Long> getSaveSuccessReportIds() {
        return new ArrayList<Long>(this.saveSuccessReportIds);
    }

    public void addSuccessReportId(List<Long> reportIds) {
        if (EmptyUtil.isEmpty(reportIds)) {
            return;
        }
        reportIds.forEach(this::addSuccessReportId);
    }

    public void addSuccessReportId(Long reportId) {
        if (EmptyUtil.isEmpty((Long)reportId)) {
            return;
        }
        this.saveSuccessReportIds.add(reportId);
    }

    public ReportTemplate getBackUpTemplate(Long sourceTemplateId) {
        return this.reportTemplateMap.get(sourceTemplateId);
    }

    public ReportGenerateMessage.MessageItem getOrRegister(Long templateId) {
        return this.reportGenerateMessage.getOrRegister(templateId);
    }

    public int getCount() {
        return this.count;
    }

    public boolean hasFailed() {
        return this.reportGenerateMessage.hasFailed();
    }

    public boolean hasSucceed() {
        return this.count > 0;
    }

    public boolean isFailed() {
        return EmptyUtil.isNoEmpty((String)this.errorMsg);
    }

    public String getMessage() {
        return this.reportGenerateMessage.getAllMessage("\r\n");
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}

