/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.generator.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGeneratePeriod;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateResult;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportOrgTemplateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.IReportGenerator;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.business.utils.LogHelper;

public class RepeatFilterReportGeneratorImpl
implements IReportGenerator {
    @Override
    public ReportGenerateResult generateReport(List<ReportGenerateInfo> reportGenerateInfoList) {
        HashSet<Long> templateIds = new HashSet<Long>(16);
        HashSet<Long> reportPeriodIds = new HashSet<Long>(4);
        ReportGenerateResult reportGenerateResult = new ReportGenerateResult();
        for (ReportGenerateInfo reportGenerateInfo : reportGenerateInfoList) {
            ReportOrgTemplateInfo reportOrgTemplateInfo = reportGenerateInfo.getReportOrgTemplateInfo();
            templateIds.add(reportOrgTemplateInfo.getReportTemplate().getId());
            reportOrgTemplateInfo.getChildTemplateList().stream().map(ReportTemplate::getId).forEach(templateIds::add);
            reportPeriodIds.add(reportGenerateInfo.getReportGeneratePeriod().getPeriodMember().getId());
        }
        BitMap<Long, ReportInfo> reportInfoBitMap = this.queryGeneratedReportInfoBitMap(templateIds, reportPeriodIds);
        if (reportInfoBitMap.isEmpty()) {
            return reportGenerateResult;
        }
        LogHelper logHelper = LogHelper.get(RepeatFilterReportGeneratorImpl.class);
        Iterator<ReportGenerateInfo> iterator = reportGenerateInfoList.iterator();
        while (iterator.hasNext()) {
            ReportGenerateInfo reportGenerateInfo = iterator.next();
            ReportOrgTemplateInfo reportOrgTemplateInfo = reportGenerateInfo.getReportOrgTemplateInfo();
            ReportGeneratePeriod reportGeneratePeriod = reportGenerateInfo.getReportGeneratePeriod();
            Set<Long> keys = ListHelper.asSet(reportGeneratePeriod.getPeriodMember().getId());
            keys.add(reportOrgTemplateInfo.getOrgMember().getId());
            HashSet<Long> templateIdSet = new HashSet<Long>(16);
            templateIdSet.add(reportOrgTemplateInfo.getReportTemplate().getId());
            reportOrgTemplateInfo.getChildTemplateList().stream().map(ReportTemplate::getId).forEach(templateIdSet::add);
            List<ReportInfo> reportInfoList = reportInfoBitMap.findList(keys);
            Optional<ReportInfo> any = reportInfoList.stream().filter(reportInfo -> templateIdSet.contains(((ReportInfo)reportInfo).templateId)).findAny();
            if (!any.isPresent()) continue;
            ReportInfo reportInfo2 = any.get();
            logHelper.logger("template:{} ,reportOrg:{}, reportPeriod:{} has generated report:{} ", reportOrgTemplateInfo.getReportTemplate().getName(), reportOrgTemplateInfo.getOrgMember().getName(), reportGeneratePeriod.getPeriodMember().getName(), reportInfo2.reportId);
            iterator.remove();
        }
        logHelper.info();
        if (EmptyUtil.isEmpty(reportGenerateInfoList)) {
            reportGenerateResult.setErrorMsg(ResManager.loadKDString((String)"\u6240\u6709\u6a21\u677f\u5df2\u751f\u6210\u5bf9\u5e94\u7684\u8ba1\u5212\u5355\u636e\uff0c\u4e0d\u518d\u91cd\u590d\u751f\u6210", (String)"RepeatFilterReportGeneratorImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return reportGenerateResult;
    }

    private BitMap<Long, ReportInfo> queryGeneratedReportInfoBitMap(Set<Long> templateIds, Set<Long> reportPeriodIds) {
        QFilter qFilter = new QFilter("template.id", "in", templateIds).and(new QFilter("reportperiod", "in", reportPeriodIds));
        String selectFields = String.join((CharSequence)",", "id", "reportperiod", "reportorg", "template.id");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        BitMap<Long, ReportInfo> reportInfoBitMap = new BitMap<Long, ReportInfo>(16);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            long reportId = dynamicObject.getLong("id");
            long reportPeriodId = dynamicObject.getLong("reportperiod");
            long reportOrgId = dynamicObject.getLong("reportorg");
            long templateId = dynamicObject.getLong("template.id");
            ReportInfo reportInfo = new ReportInfo(reportId, reportOrgId, reportPeriodId, templateId);
            reportInfoBitMap.addValue(ListHelper.asSet(reportInfo.reportOrgId, reportInfo.reportPeriodId, reportInfo.templateId), reportInfo);
        }
        return reportInfoBitMap;
    }

    static class ReportInfo {
        private final Long reportId;
        private final Long reportOrgId;
        private final Long reportPeriodId;
        private final Long templateId;

        public ReportInfo(Long reportId, Long reportOrgId, Long reportPeriodId, Long templateId) {
            this.reportId = reportId;
            this.reportOrgId = reportOrgId;
            this.reportPeriodId = reportPeriodId;
            this.templateId = templateId;
        }
    }
}

