/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.generator.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateResult;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.IReportGenerator;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.impl.AbstractReportGenerator;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.impl.RepeatFilterReportGeneratorImpl;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;

public class ReportEffectedFilterGeneratorImpl
extends AbstractReportGenerator {
    public ReportEffectedFilterGeneratorImpl(FundPlanSystem fundPlanSystem, IReportGenerator reportGenerator) {
        super(fundPlanSystem, reportGenerator);
    }

    public ReportEffectedFilterGeneratorImpl(AbstractReportGenerator abstractReportGenerator) {
        super(abstractReportGenerator);
    }

    public ReportEffectedFilterGeneratorImpl(FundPlanSystem fundPlanSystem) {
        super(fundPlanSystem, new RepeatFilterReportGeneratorImpl());
    }

    @Override
    public ReportGenerateResult generateReport(List<ReportGenerateInfo> reportGenerateInfoList) {
        ReportGenerateResult reportGenerateResult = super.generateReport(reportGenerateInfoList);
        List generateInfoList = reportGenerateInfoList.stream().filter(reportGenerateInfo -> reportGenerateInfo.getReportOrgTemplateInfo().getReportTemplate().getTemplateUse().isSummary()).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(generateInfoList)) {
            return reportGenerateResult;
        }
        HashMap<Long, Set<Long>> childParentOrgIdMap = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> reportPeriodIds = new HashSet<Long>(16);
        for (ReportGenerateInfo reportGenerateInfo2 : generateInfoList) {
            OrgMember orgMember = reportGenerateInfo2.getReportOrgTemplateInfo().getOrgMember();
            orgMember.getAllChildMember().stream().map(DimMember::getId).forEach(cId -> childParentOrgIdMap.computeIfAbsent((Long)cId, k -> new HashSet(16)).add(orgMember.getId()));
            reportPeriodIds.add(reportGenerateInfo2.getReportGeneratePeriod().getPeriodMember().getId());
        }
        BitMap<Long, Long> effectedReportBitMap = this.getEffectedReportBitMap(childParentOrgIdMap, reportPeriodIds);
        if (effectedReportBitMap.isEmpty()) {
            return reportGenerateResult;
        }
        LinkedHashSet<String> periodNames = new LinkedHashSet<String>(16);
        LinkedHashSet<String> sumOrgNames = new LinkedHashSet<String>(16);
        for (ReportGenerateInfo reportGenerateInfo3 : generateInfoList) {
            Long orgId;
            Long reportPeriodId = reportGenerateInfo3.getReportGeneratePeriod().getPeriodMember().getId();
            Long one = effectedReportBitMap.findOne(ListHelper.asSet(reportPeriodId, orgId = reportGenerateInfo3.getReportOrgTemplateInfo().getOrgMember().getId()));
            if (EmptyUtil.isEmpty((Long)one)) continue;
            reportGenerateInfoList.remove(reportGenerateInfo3);
            periodNames.add(reportGenerateInfo3.getReportGeneratePeriod().getPeriodMember().getName());
            sumOrgNames.add(reportGenerateInfo3.getReportOrgTemplateInfo().getOrgMember().getName());
        }
        if (EmptyUtil.isNoEmpty(periodNames) && EmptyUtil.isNoEmpty(sumOrgNames)) {
            String message = String.format(ResManager.loadKDString((String)"%1$s\u5f53\u671f\u5b58\u5728\u5df2\u751f\u6548\u7684\u4e0b\u7ea7\u7f16\u62a5\u4e3b\u4f53\u8d44\u91d1\u8ba1\u5212\u5355\u636e\uff0c\u6682\u4e0d\u751f\u6210\u6c47\u603b\u4e3b\u4f53\u201c%2$s\u201d\u7684\u6c47\u603b\u5355\u636e\u3002", (String)"ReportEffectedFilterGeneratorImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", periodNames), String.join((CharSequence)"\u3001", sumOrgNames));
            reportGenerateResult.getOrRegister(0L).addMessage(message);
        }
        return reportGenerateResult;
    }

    private BitMap<Long, Long> getEffectedReportBitMap(Map<Long, Set<Long>> childParentOrgIdMap, Set<Long> reportPeriodIds) {
        String selectFields = String.join((CharSequence)",", "id", "reportperiod", "reportorg");
        Set<Long> allChildren = childParentOrgIdMap.keySet();
        String mainTableProp = String.join((CharSequence)".", "template", "ismaintable");
        String reportPlanUse = String.join((CharSequence)".", "template", "templateuses");
        QFilter qFilter = new QFilter("reportorg", "in", allChildren).and(new QFilter("reportperiod", "in", reportPeriodIds)).and(new QFilter(mainTableProp, "=", (Object)true)).and(new QFilter(reportPlanUse, "=", (Object)TemplateUseType.PLANING.getNumber())).and(new QFilter("planstatus", "=", (Object)ReportPlanStatusEnum.EFFECTIVE.getValue()));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        BitMap<Long, Long> bitMap = new BitMap<Long, Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long reportId = dynamicObject.getLong("id");
            long reportPeriodId = dynamicObject.getLong("reportperiod");
            long reportOrgId = dynamicObject.getLong("reportorg");
            HashSet<Long> parentOrgIds = new HashSet<Long>(childParentOrgIdMap.getOrDefault(reportOrgId, Collections.emptySet()));
            parentOrgIds.add(reportPeriodId);
            bitMap.addValue(parentOrgIds, (Long)reportId);
        }
        return bitMap;
    }
}

