/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.generator.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.report.generate.creator.ReportCreator;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateResult;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportOrgTemplateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.IReportGenerator;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.impl.AbstractReportGenerator;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.impl.ReportTemplateBakReportGeneratorImpl;

public class ReportPlanGeneratorImpl
extends AbstractReportGenerator {
    private static final Log logger = LogFactory.getLog(ReportPlanGeneratorImpl.class);
    private final IReportRepository reportRepo = new ReportRepository();

    public ReportPlanGeneratorImpl(FundPlanSystem fundPlanSystem, IReportGenerator reportGenerator) {
        super(fundPlanSystem, reportGenerator);
    }

    public ReportPlanGeneratorImpl(FundPlanSystem fundPlanSystem) {
        super(new ReportTemplateBakReportGeneratorImpl(fundPlanSystem));
    }

    @Override
    public ReportGenerateResult generateReport(List<ReportGenerateInfo> reportGenerateInfoList) {
        ReportGenerateResult reportGenerateResult = super.generateReport(reportGenerateInfoList);
        if (EmptyUtil.isEmpty(reportGenerateInfoList)) {
            return reportGenerateResult;
        }
        logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u7f16\u62a5\u7c7b\u578b\uff1a{}\uff0c\u5f00\u59cb\u751f\u6210\u8ba1\u5212\u7f16\u5236\u8868", (Object)this.fundPlanSystem.getName(), (Object)reportGenerateInfoList.get(0).getReportGeneratePeriod().getPeriodMember().getPeriodTypeId());
        ReportCreator reportCreator = new ReportCreator(this.fundPlanSystem, reportGenerateInfoList.get(0).getReportGeneratePeriod().getPeriodMember().getPeriodTypeId());
        ArrayList<Report> reportResultList = new ArrayList<Report>(16);
        for (ReportGenerateInfo reportGenerateInfo : reportGenerateInfoList) {
            ReportOrgTemplateInfo reportOrgTemplateInfo = reportGenerateInfo.getReportOrgTemplateInfo();
            ReportTemplate reportTemplate = reportOrgTemplateInfo.getReportTemplate();
            if (reportTemplate.getTemplateUse().isSummary()) continue;
            List<Report> reportList = this.doGenerateReport(reportGenerateResult, reportGenerateInfo, reportCreator);
            reportResultList.addAll(reportList);
        }
        if (EmptyUtil.isNoEmpty(reportResultList)) {
            logger.info("\u5171\u751f\u6210\u8ba1\u5212\u7f16\u5236\u8868\uff1a{}", (Object)reportResultList.size());
            List<Long> reportIdList = this.reportRepo.saveReportWithoutData(reportResultList);
            reportGenerateResult.addSuccessReportId(reportIdList);
        }
        return reportGenerateResult;
    }

    private List<Report> doGenerateReport(ReportGenerateResult reportGenerateResult, ReportGenerateInfo reportGenerateInfo, ReportCreator reportCreator) {
        ReportOrgTemplateInfo reportOrgTemplateInfo = reportGenerateInfo.getReportOrgTemplateInfo();
        ArrayList<ReportTemplate> templateList = new ArrayList<ReportTemplate>(reportOrgTemplateInfo.getChildTemplateList());
        templateList.add(reportOrgTemplateInfo.getReportTemplate());
        ArrayList<Report> reportList = new ArrayList<Report>(templateList.size());
        for (ReportTemplate template : templateList) {
            ReportTemplate backUpTemplate = reportGenerateResult.getBackUpTemplate(template.getId());
            if (backUpTemplate == null) {
                logger.error("\u6a21\u677f\uff1a{}\u672a\u5907\u4efd.", (Object)template.getName());
                return Collections.emptyList();
            }
            backUpTemplate = backUpTemplate.serializeClone();
            Report report = reportCreator.createReport(reportGenerateInfo, backUpTemplate);
            this.fillBackTemplate(report, backUpTemplate);
            reportGenerateResult.addReport(report);
            reportList.add(report);
        }
        return reportList;
    }

    private void fillBackTemplate(Report report, ReportTemplate backUpTemplate) {
        List<TemplateDim> allTemplateDim = backUpTemplate.getAllTemplateDim();
        for (TemplateDim templateDim : allTemplateDim) {
            DimensionType dimType = templateDim.getDimType();
            if (dimType.isOrgDim()) {
                templateDim.setMemberScope(report.getCompanyMemberList().stream().map(DimMember::getId).collect(Collectors.toList()));
                continue;
            }
            if (!dimType.isPeriodDim()) continue;
            templateDim.setMemberScope(report.getPeriodMemberList().stream().map(DimMember::getId).collect(Collectors.toList()));
        }
    }
}

