/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.generator.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateResult;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportOrgTemplateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.IReportGenerator;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.impl.AbstractReportGenerator;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.impl.ReportEffectedFilterGeneratorImpl;

public class ReportTemplateBakReportGeneratorImpl
extends AbstractReportGenerator {
    private static final Log logger = LogFactory.getLog(ReportTemplateBakReportGeneratorImpl.class);
    private final ITemplateRepository templateRepository = new TemplateRepository();

    public ReportTemplateBakReportGeneratorImpl(FundPlanSystem fundPlanSystem, IReportGenerator reportGenerator) {
        super(fundPlanSystem, reportGenerator);
    }

    public ReportTemplateBakReportGeneratorImpl(FundPlanSystem fundPlanSystem) {
        this(fundPlanSystem, new ReportEffectedFilterGeneratorImpl(fundPlanSystem));
    }

    public ReportTemplateBakReportGeneratorImpl(AbstractReportGenerator abstractReportGenerator) {
        super(abstractReportGenerator);
    }

    @Override
    public ReportGenerateResult generateReport(List<ReportGenerateInfo> reportGenerateInfoList) {
        ReportGenerateResult reportGenerateResult = super.generateReport(reportGenerateInfoList);
        ArrayList<Long> needBackupTemplateIdList = new ArrayList<Long>(16);
        for (ReportGenerateInfo reportGenerateInfo : reportGenerateInfoList) {
            ReportOrgTemplateInfo reportOrgTemplateInfo = reportGenerateInfo.getReportOrgTemplateInfo();
            needBackupTemplateIdList.add(reportOrgTemplateInfo.getReportTemplate().getId());
            reportOrgTemplateInfo.getChildTemplateList().stream().map(ReportTemplate::getId).forEach(needBackupTemplateIdList::add);
            List<ReportTemplate> statAnalysisTemplateList = reportOrgTemplateInfo.getReportTemplate().getStatAnalysisTemplateList();
            if (!EmptyUtil.isNoEmpty(statAnalysisTemplateList)) continue;
            statAnalysisTemplateList.forEach(statAnalysisTemplate -> needBackupTemplateIdList.add(statAnalysisTemplate.getId()));
        }
        if (EmptyUtil.isEmpty(needBackupTemplateIdList)) {
            return reportGenerateResult;
        }
        logger.info("\u5171\u5907\u4efd\u6a21\u677f\uff1a{}\uff0c\u6a21\u677fids:{}", (Object)needBackupTemplateIdList.size(), needBackupTemplateIdList);
        List<ReportTemplate> backupTemplateList = this.templateRepository.backupTemplateList(needBackupTemplateIdList);
        for (ReportTemplate backupTemplate : backupTemplateList) {
            reportGenerateResult.addTemplate(backupTemplate);
        }
        return reportGenerateResult;
    }
}

