/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.generator.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.SumPlanSumType;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;
import kd.tmc.fpm.business.mvc.service.report.generate.creator.ReportCreator;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateResult;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportOrgTemplateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.IReportGenerator;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.impl.AbstractReportGenerator;
import kd.tmc.fpm.business.mvc.service.report.generate.generator.impl.ReportPlanGeneratorImpl;
import org.apache.commons.collections4.CollectionUtils;

public class SumPlanReportGeneratorImpl
extends AbstractReportGenerator {
    private static final Log logger = LogFactory.getLog(SumPlanReportGeneratorImpl.class);
    private final ISumPlanRepository sumPlanRepository = new SumPlanRepository();
    private final IReportRepository reportRepository = new ReportRepository();
    private final ISumPlanBizService iSumPlanBizService = new SumPlanBizServiceImpl();

    public SumPlanReportGeneratorImpl(FundPlanSystem fundPlanSystem, IReportGenerator reportGenerator) {
        super(fundPlanSystem, reportGenerator);
    }

    public SumPlanReportGeneratorImpl(AbstractReportGenerator abstractReportGenerator) {
        super(abstractReportGenerator);
    }

    public SumPlanReportGeneratorImpl(FundPlanSystem fundPlanSystem) {
        super(new ReportPlanGeneratorImpl(fundPlanSystem));
    }

    @Override
    public ReportGenerateResult generateReport(List<ReportGenerateInfo> reportGenerateInfoList) {
        ReportGenerateResult reportGenerateResult = super.generateReport(reportGenerateInfoList);
        if (EmptyUtil.isEmpty(reportGenerateInfoList)) {
            return reportGenerateResult;
        }
        ReportCreator reportCreator = new ReportCreator(this.fundPlanSystem, reportGenerateInfoList.get(0).getReportGeneratePeriod().getPeriodMember().getPeriodTypeId());
        ArrayList<Report> sumPlanReportList = new ArrayList<Report>(16);
        for (ReportGenerateInfo reportGenerateInfo : reportGenerateInfoList) {
            SumPlanReport sumPlanReport;
            ReportTemplate reportTemplate = reportGenerateInfo.getReportOrgTemplateInfo().getReportTemplate();
            if (reportTemplate.getTemplateUse().isPlan() || (sumPlanReport = this.doGenerateReport(reportGenerateResult, reportGenerateInfo, reportCreator)) == null) continue;
            sumPlanReportList.add(sumPlanReport);
        }
        if (EmptyUtil.isEmpty(sumPlanReportList)) {
            return reportGenerateResult;
        }
        logger.info("\u751f\u6210\u6c47\u603b\u7f16\u5236\uff1a{}\u4e2a", (Object)sumPlanReportList.size());
        List<SumPlanRecord> sumPlanRecordList = sumPlanReportList.stream().map(i -> this.createSumPlanRecord((Report)i, reportGenerateResult)).collect(Collectors.toList());
        List<Long> successReportIds = this.reportRepository.saveReportWithoutData(sumPlanReportList);
        List<Long> sumPlanRecordIdList = this.sumPlanRepository.saveSumPlanRecord(sumPlanRecordList);
        if (CollectionUtils.isNotEmpty(sumPlanRecordIdList)) {
            for (Long sumRecordId : sumPlanRecordIdList) {
                FpmOperateResult<Void> voidFpmOperateResult = this.iSumPlanBizService.sumReportSumAllData(sumRecordId);
                if (voidFpmOperateResult.isSuccess()) continue;
                throw new KDBizException(JSON.toJSONString(voidFpmOperateResult.getMessageList()));
            }
        }
        reportGenerateResult.addSuccessReportId(successReportIds);
        return reportGenerateResult;
    }

    private SumPlanRecord createSumPlanRecord(Report sumPlanReport, ReportGenerateResult reportGenerateResult) {
        Long sumOrgId = sumPlanReport.getCompanyMemberList().get(0).getId();
        List<PeriodMember> periodMemberList = sumPlanReport.getPeriodMemberList();
        Long reportPeriodId = periodMemberList.get(0).getId();
        ReportTemplate template = sumPlanReport.getTemplate();
        List<Long> currencyIds = template.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.CURRENCY).map(TemplateDim::getMemberScope).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        int count = 1;
        List<ReportTemplate> statAnalysisTemplateList = template.getStatAnalysisTemplateList();
        ArrayList<Long> statAnalysisTemplateIdList = new ArrayList<Long>(8);
        if (EmptyUtil.isNoEmpty(statAnalysisTemplateList)) {
            count += statAnalysisTemplateList.size();
            statAnalysisTemplateList.forEach(ast -> {
                ReportTemplate backUpTemplate = reportGenerateResult.getBackUpTemplate(ast.getId());
                if (backUpTemplate == null) {
                    return;
                }
                statAnalysisTemplateIdList.add(backUpTemplate.getId());
            });
        }
        SumPlanRecord sumPlanRecord = new SumPlanRecord();
        sumPlanRecord.setSumPlanReportIdList(periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList()));
        sumPlanRecord.setSystemId(sumPlanReport.getSystemId());
        sumPlanRecord.setName(sumPlanReport.getName());
        sumPlanRecord.setReportStatus(ReportStatus.DISABLE);
        sumPlanRecord.setReportOrg(sumOrgId);
        sumPlanRecord.setReportType(periodMemberList.get(0).getPeriodTypeId());
        sumPlanRecord.setReportPeriod(reportPeriodId);
        sumPlanRecord.setOriginalReportIdList(Collections.singletonList(sumPlanReport.getId()));
        sumPlanRecord.setSumPlanSumType(SumPlanSumType.REPORTPLAN);
        sumPlanRecord.setOrgId(sumOrgId);
        sumPlanRecord.setReportPeriodTypeId(sumPlanReport.getReportPeriodType().getReportPeriodId());
        sumPlanRecord.setReportPeriodId(reportPeriodId);
        sumPlanRecord.setCurrencyIdList(currencyIds);
        sumPlanRecord.setReportCount(count);
        sumPlanRecord.setExchangeRateTableId(sumPlanReport.getExchangeRateTableId());
        sumPlanRecord.setRateDate(sumPlanReport.getExchangeRateDate());
        sumPlanRecord.setAmountUnit(template.getAmountUnit());
        sumPlanRecord.setSumPlanReportIdList(Collections.singletonList(sumPlanReport.getId()));
        sumPlanRecord.setAttachtplIdList(statAnalysisTemplateIdList);
        sumPlanRecord.setDeclareStartDate(sumPlanReport.getStartDate());
        sumPlanRecord.setDeclareEndDate(sumPlanReport.getCloseDate());
        sumPlanRecord.setPeriodMemberIdList(periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList()));
        return sumPlanRecord;
    }

    private SumPlanReport doGenerateReport(ReportGenerateResult reportGenerateResult, ReportGenerateInfo reportGenerateInfo, ReportCreator reportCreator) {
        ReportOrgTemplateInfo reportOrgTemplateInfo = reportGenerateInfo.getReportOrgTemplateInfo();
        ReportTemplate reportTemplate = reportOrgTemplateInfo.getReportTemplate();
        ReportTemplate backUpTemplate = reportGenerateResult.getBackUpTemplate(reportTemplate.getId());
        if (backUpTemplate == null) {
            logger.error("\u6a21\u677f\uff1a{}\u672a\u5907\u4efd.", (Object)reportTemplate.getName());
            return null;
        }
        backUpTemplate = backUpTemplate.serializeClone();
        SumPlanReport report = (SumPlanReport)reportCreator.createReport(reportGenerateInfo, backUpTemplate);
        this.fillBackTemplate(report, backUpTemplate);
        reportGenerateResult.addReport(report);
        return report;
    }

    private void fillBackTemplate(SumPlanReport sumPlanReport, ReportTemplate backUpTemplate) {
        List<TemplateDim> allTemplateDim = backUpTemplate.getAllTemplateDim();
        OrgMember sumOrgMember = sumPlanReport.getCompanyMemberList().get(0);
        for (TemplateDim templateDim : allTemplateDim) {
            DimensionType dimType = templateDim.getDimType();
            if (dimType.isPeriodDim()) {
                templateDim.setMemberScope(sumPlanReport.getPeriodMemberList().stream().map(DimMember::getId).collect(Collectors.toList()));
                continue;
            }
            if (!dimType.isOrgDim()) continue;
            ArrayList<Long> memberScope = new ArrayList<Long>(16);
            Optional<TemplateDim> first = backUpTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.ORG).findFirst();
            if (!first.isPresent()) continue;
            TemplateDim orgTplDim = first.get();
            TemplateDimMemScopeType scopeType = orgTplDim.getScopeType();
            if (TemplateDimMemScopeType.DIRECT_SUB_LEVEL == scopeType) {
                List<DimMember> childrenS = sumOrgMember.getChildren();
                memberScope.add(sumOrgMember.getId());
                memberScope.addAll(childrenS.stream().map(DimMember::getId).collect(Collectors.toList()));
            } else if (TemplateDimMemScopeType.SUM_NODE_THIS_LEVEL == scopeType) {
                memberScope.add(sumOrgMember.getId());
            } else {
                memberScope = orgTplDim.getMemberScope();
            }
            templateDim.setMemberScope(memberScope);
        }
    }
}

