/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.mvc.service.report.generate.IReportGenerateInfoGenerate;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGenerateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGeneratePeriod;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportOrgTemplateInfo;
import kd.tmc.fpm.business.mvc.service.report.generate.filter.IReportOrgTemplateInfoFilter;
import kd.tmc.fpm.business.mvc.service.report.generate.strategy.IReportGeneratePeriodStrategy;
import kd.tmc.fpm.business.utils.LogHelper;

public class DefaultReportGenerateInfoGenerateImpl
implements IReportGenerateInfoGenerate {
    private static final Log logger = LogFactory.getLog(DefaultReportGenerateInfoGenerateImpl.class);
    private final ITemplateRepository templateRepository;
    private final ReportPrepare reportPrepare;
    private final FundPlanSystem fundPlanSystem;
    private final IReportGeneratePeriodStrategy reportGeneratePeriodStrategy;
    private final List<IReportOrgTemplateInfoFilter> reportOrgTemplateInfoFilterList;

    public DefaultReportGenerateInfoGenerateImpl(ReportPrepare reportPrepare, FundPlanSystem fundPlanSystem, IReportGeneratePeriodStrategy reportGeneratePeriodStrategy) {
        this.reportPrepare = reportPrepare;
        this.fundPlanSystem = fundPlanSystem;
        this.templateRepository = new TemplateRepository();
        this.reportGeneratePeriodStrategy = reportGeneratePeriodStrategy;
        this.reportOrgTemplateInfoFilterList = new ArrayList<IReportOrgTemplateInfoFilter>(16);
    }

    public DefaultReportGenerateInfoGenerateImpl addReportOrgTemplateInfoFilter(IReportOrgTemplateInfoFilter reportOrgTemplateInfoFilter) {
        if (!this.reportOrgTemplateInfoFilterList.contains(reportOrgTemplateInfoFilter)) {
            this.reportOrgTemplateInfoFilterList.add(reportOrgTemplateInfoFilter);
        }
        return this;
    }

    @Override
    public FpmOperateResult<List<ReportGenerateInfo>> generateReportGenerateInfo() {
        List<ReportOrgTemplateInfo> reportOrgTemplateInfoList = this.getAndFilterReportOrgTemplateInfoList();
        if (EmptyUtil.isEmpty(reportOrgTemplateInfoList)) {
            logger.info("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8d44\u91d1\u8ba1\u5212\u6a21\u677f");
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8d44\u91d1\u8ba1\u5212\u6a21\u677f", (String)"DefaultReportGenerateInfoGenerateImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        FpmOperateResult<List<ReportGenerateInfo>> result = new FpmOperateResult<List<ReportGenerateInfo>>();
        List<ReportGeneratePeriod> reportGeneratePeriodList = this.reportGeneratePeriodStrategy.getReportGeneratePeriodList();
        List disabledList = reportGeneratePeriodList.stream().filter(reportGeneratePeriod -> !reportGeneratePeriod.getPeriodMember().isEnable()).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(disabledList)) {
            reportGeneratePeriodList.removeAll(disabledList);
            String disabledPeriodName = disabledList.stream().map(ReportGeneratePeriod::getPeriodMember).map(DimMember::getName).collect(Collectors.joining(","));
            result.addTipsMessage(String.format(ResManager.loadKDString((String)"\u671f\u95f4\u3010%1$s\u3011\u88ab\u7981\u7528\uff0c\u6570\u636e\u751f\u6210\u5df2\u8df3\u8fc7\u3002", (String)"DefaultReportGenerateInfoGenerateImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]), disabledPeriodName));
        }
        if (EmptyUtil.isEmpty(reportGeneratePeriodList)) {
            logger.info("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u671f\u95f4\u6210\u5458");
            result.addErrMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u671f\u95f4\u6210\u5458", (String)"DefaultReportGenerateInfoGenerateImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return result;
        }
        ArrayList<ReportGenerateInfo> reportGenerateInfoList = new ArrayList<ReportGenerateInfo>(reportOrgTemplateInfoList.size() * reportGeneratePeriodList.size());
        LogHelper logHelper = LogHelper.get(logger);
        for (ReportGeneratePeriod reportGeneratePeriod2 : reportGeneratePeriodList) {
            PeriodMember periodMember = reportGeneratePeriod2.getPeriodMember();
            Date startDate = periodMember.getStartDate();
            for (ReportOrgTemplateInfo reportOrgTemplateInfo : reportOrgTemplateInfoList) {
                ReportGeneratePeriod copy = reportGeneratePeriod2.copy();
                ReportTemplate reportTemplate = reportOrgTemplateInfo.getReportTemplate();
                Date effectiveDate = reportTemplate.getEffectiveDate();
                if (Objects.nonNull(effectiveDate) && effectiveDate.after(startDate)) {
                    logHelper.logger("period\uff1a{}\uff0cstartDate\uff1a{} less than template:{} effectiveDate\uff1a{}", periodMember, DateUtils.formatString((Date)startDate, (String)"yyyy-MM-dd"), reportTemplate.getNumber(), DateUtils.formatString((Date)effectiveDate, (String)"yyyy-MM-dd"));
                    continue;
                }
                reportGenerateInfoList.add(new ReportGenerateInfo(reportOrgTemplateInfo, copy));
            }
        }
        logHelper.info();
        if (EmptyUtil.isEmpty(reportGenerateInfoList)) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8d44\u91d1\u8ba1\u5212\u6a21\u677f", (String)"DefaultReportGenerateInfoGenerateImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return FpmOperateResult.success(reportGenerateInfoList);
    }

    private List<ReportOrgTemplateInfo> getAndFilterReportOrgTemplateInfoList() {
        List<ReportOrgTemplateInfo> reportOrgTemplateInfoList = this.doGetReportOrgTemplateInfoList();
        for (IReportOrgTemplateInfoFilter reportOrgTemplateInfoFilter : this.reportOrgTemplateInfoFilterList) {
            reportOrgTemplateInfoList = reportOrgTemplateInfoFilter.filter(reportOrgTemplateInfoList);
        }
        return reportOrgTemplateInfoList;
    }

    private List<ReportOrgTemplateInfo> doGetReportOrgTemplateInfoList() {
        List<ReportTemplate> templateList = this.templateRepository.loadTemplateByPeriodType(this.fundPlanSystem.getId(), this.reportPrepare.getReportPeriodId());
        Map<Long, List> templateAndSubMap = templateList.stream().filter(ReportTemplate::isEnable).filter(ReportTemplate::isRelease).filter(ReportTemplate::isMainTable).collect(Collectors.toMap(ReportTemplate::getId, item -> item.getAccountSettings().stream().map(TemplateAccountSetting::getChildTemplateId).filter(EmptyUtil::isNoEmpty).distinct().collect(Collectors.toList()), (o1, o2) -> o1));
        Map reportTemplateMap = templateList.stream().collect(Collectors.toMap(ReportTemplate::getId, Function.identity(), (a, b) -> a));
        ArrayList<ReportOrgTemplateInfo> reportOrgTemplateInfoList = new ArrayList<ReportOrgTemplateInfo>(16);
        Dimension orgDim = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.ORG);
        Map orgMemberMap = orgDim.getAllDimMemberList().stream().map(OrgMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        for (Map.Entry<Long, List> entry : templateAndSubMap.entrySet()) {
            Long mainTemplateId = entry.getKey();
            ReportTemplate mainReportTemplate = (ReportTemplate)reportTemplateMap.get(mainTemplateId);
            List<Long> userIdList = mainReportTemplate.getUserIdList();
            if (EmptyUtil.isEmpty(userIdList)) {
                logger.info("\u6a21\u677f\uff1a{}\uff0cid:{}\uff0c\u5c1a\u672a\u5206\u914d\u7f16\u62a5\u4e3b\u4f53\u3002", (Object)mainReportTemplate.getName(), (Object)mainTemplateId);
                continue;
            }
            for (Long userId : userIdList) {
                OrgMember orgMember = (OrgMember)orgMemberMap.get(userId);
                if (orgMember == null) {
                    logger.info("\u6a21\u677f:{}\uff0cid:{}\uff0c\u5206\u914d\u7684\u7f16\u62a5\u4e3b\u4f53id\uff1a{},\u5bf9\u5e94\u7684\u7f16\u62a5\u4e3b\u4f53\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", new Object[]{mainReportTemplate.getName(), mainTemplateId, userId});
                    continue;
                }
                ReportOrgTemplateInfo reportOrgTemplateInfo = new ReportOrgTemplateInfo(orgMember, mainReportTemplate);
                templateAndSubMap.getOrDefault(mainTemplateId, Collections.emptyList()).stream().map(reportTemplateMap::get).forEach(reportOrgTemplateInfo::addChildTemplate);
                reportOrgTemplateInfoList.add(reportOrgTemplateInfo);
            }
        }
        return reportOrgTemplateInfoList;
    }
}

