/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.strategy.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGeneratePeriod;
import kd.tmc.fpm.business.mvc.service.report.generate.strategy.IReportGeneratePeriodStrategy;

public abstract class AbstractReportGeneratePeriodStrategy
implements IReportGeneratePeriodStrategy {
    private IReportGeneratePeriodStrategy reportGeneratePeriodStrategy;
    protected ReportPrepare reportPrepare;
    protected FundPlanSystem fundPlanSystem;
    protected Map<Long, PeriodMember> periodMemberMap;

    public AbstractReportGeneratePeriodStrategy(ReportPrepare reportPrepare, FundPlanSystem fundPlanSystem) {
        this.reportPrepare = reportPrepare;
        this.fundPlanSystem = fundPlanSystem;
        this.init();
    }

    public AbstractReportGeneratePeriodStrategy(AbstractReportGeneratePeriodStrategy abstractReportGeneratePeriodStrategy) {
        this.reportGeneratePeriodStrategy = abstractReportGeneratePeriodStrategy;
        this.periodMemberMap = new HashMap<Long, PeriodMember>(2);
        this.reportPrepare = abstractReportGeneratePeriodStrategy.reportPrepare;
        this.fundPlanSystem = abstractReportGeneratePeriodStrategy.fundPlanSystem;
        this.periodMemberMap = abstractReportGeneratePeriodStrategy.periodMemberMap;
    }

    public AbstractReportGeneratePeriodStrategy(IReportGeneratePeriodStrategy reportGeneratePeriodStrategy, ReportPrepare reportPrepare, FundPlanSystem fundPlanSystem) {
        this.reportGeneratePeriodStrategy = reportGeneratePeriodStrategy;
        this.reportPrepare = reportPrepare;
        this.fundPlanSystem = fundPlanSystem;
        this.init();
    }

    private void init() {
        Dimension periodDim = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        this.periodMemberMap = periodDim.getAllDimMemberList().stream().map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
    }

    @Override
    public List<ReportGeneratePeriod> getReportGeneratePeriodList() {
        if (Objects.nonNull(this.reportGeneratePeriodStrategy)) {
            return this.reportGeneratePeriodStrategy.getReportGeneratePeriodList();
        }
        throw new UnsupportedOperationException();
    }
}

