/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.strategy.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.FixedFrequencyType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGeneratePeriod;
import kd.tmc.fpm.business.mvc.service.report.generate.strategy.impl.AbstractReportGeneratePeriodStrategy;

public class DefaultFixFrequencyGeneratePeriodStrategy
extends AbstractReportGeneratePeriodStrategy {
    private final int count;
    private static final Log logger = LogFactory.getLog(DefaultFixFrequencyGeneratePeriodStrategy.class);

    public DefaultFixFrequencyGeneratePeriodStrategy(ReportPrepare reportPrepare, FundPlanSystem fundPlanSystem) {
        this(reportPrepare, fundPlanSystem, 1);
    }

    public DefaultFixFrequencyGeneratePeriodStrategy(ReportPrepare reportPrepare, FundPlanSystem fundPlanSystem, int count) {
        super(reportPrepare, fundPlanSystem);
        this.count = count;
    }

    @Override
    public List<ReportGeneratePeriod> getReportGeneratePeriodList() {
        Long reportPeriodId = this.reportPrepare.getReportPeriodId();
        Optional<ReportPeriodType> first = this.fundPlanSystem.getReportTypeList().stream().filter(ReportPeriodType::isEnable).filter(reportPeriodType -> Objects.equals(reportPeriodType.getReportPeriodId(), reportPeriodId)).findFirst();
        if (!first.isPresent()) {
            logger.warn("\u4f53\u7cfb\uff1a{\u3011\uff0c\u7f16\u62a5\u7c7b\u578bid\uff1a{}\uff0c\u4e0d\u53ef\u7528\u6216\u5df2\u5220\u9664\u3002", (Object)this.fundPlanSystem.getName(), (Object)reportPeriodId);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1%s\u3011\u4e0d\u5b58\u5728\u5f53\u524d\u53ef\u7528\u7684\u7f16\u62a5\u7c7b\u578b\u3002", (String)"DefaultFixFrequencyGeneratePeriodStrategy_0", (String)"tmc-fpm-business", (Object[])new Object[0]), this.fundPlanSystem.getName());
            throw new KDBizException(errorMsg);
        }
        ReportPeriodType reportPeriodType2 = first.get();
        List sortedPeriodMemberList = this.periodMemberMap.values().stream().filter(periodMember -> Objects.equals(periodMember.getPeriodTypeId(), reportPeriodId)).filter(periodMember -> Objects.equals((Object)periodMember.getPeriodType(), (Object)reportPeriodType2.getPeriodType())).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(sortedPeriodMemberList)) {
            logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u7f16\u62a5\u51c6\u5907\uff1a{}\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u671f\u95f4\u6210\u5458", (Object)this.fundPlanSystem.getName(), (Object)this.reportPrepare.getNumber());
            return Collections.emptyList();
        }
        FixedFrequencyType fixedFrequencyStartType = this.reportPrepare.getFixedFrequencyStartType();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.getCurrentDate());
        int calendarFieldType = fixedFrequencyStartType.getCalendarFieldType();
        calendar.add(calendarFieldType, 1);
        int calendarDateFieldType = fixedFrequencyStartType.getCalendarDateFieldType();
        calendar.set(calendarDateFieldType, 1);
        logger.info("\u5373\u5c06\u751f\u6210\uff1a{}\u4e2a\u7684\u7f16\u62a5\u671f\u95f4", (Object)this.count);
        ArrayList<ReportGeneratePeriod> reportGeneratePeriodList = new ArrayList<ReportGeneratePeriod>(this.count);
        Date date = calendar.getTime();
        for (PeriodMember periodMember2 : sortedPeriodMemberList) {
            Date startDate;
            Date endDate = periodMember2.getEndDate();
            if (endDate.before(date) || (startDate = periodMember2.getStartDate()).after(date)) continue;
            reportGeneratePeriodList.add(new ReportGeneratePeriod(periodMember2));
            if (reportGeneratePeriodList.size() < this.count) continue;
            break;
        }
        String periodNames = reportGeneratePeriodList.stream().map(ReportGeneratePeriod::getPeriodMember).map(DimMember::getName).collect(Collectors.joining("\u3001"));
        logger.info("\u5b9e\u9645\u751f\u6210\u7684\u7f16\u62a5\u671f\u95f4\u4e2a\u6570\uff1a{}\uff0c\u7f16\u62a5\u671f\u95f4\u540d\u79f0:{}", (Object)reportGeneratePeriodList.size(), (Object)periodNames);
        return reportGeneratePeriodList;
    }
}

