/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.report.generate.strategy.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.FixedFrequencyType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.mvc.service.report.generate.domain.ReportGeneratePeriod;
import kd.tmc.fpm.business.mvc.service.report.generate.strategy.impl.AbstractReportGeneratePeriodStrategy;
import kd.tmc.fpm.business.mvc.service.report.generate.strategy.impl.DefaultFixFrequencyGeneratePeriodStrategy;

public class FixedFrequencyDateReportGeneratePeriodStrategy
extends AbstractReportGeneratePeriodStrategy {
    public FixedFrequencyDateReportGeneratePeriodStrategy(ReportPrepare reportPrepare, FundPlanSystem fundPlanSystem) {
        this(new DefaultFixFrequencyGeneratePeriodStrategy(reportPrepare, fundPlanSystem));
    }

    public FixedFrequencyDateReportGeneratePeriodStrategy(AbstractReportGeneratePeriodStrategy reportGeneratePeriodStrategy) {
        super(reportGeneratePeriodStrategy);
    }

    @Override
    public List<ReportGeneratePeriod> getReportGeneratePeriodList() {
        List<ReportGeneratePeriod> reportGeneratePeriodList = super.getReportGeneratePeriodList();
        if (EmptyUtil.isEmpty(reportGeneratePeriodList)) {
            return reportGeneratePeriodList;
        }
        FixedFrequencyType fixedFrequencyStartType = this.reportPrepare.getFixedFrequencyStartType();
        int frequencyStartDate = this.reportPrepare.getFixedFrequencyStartDate();
        FixedFrequencyType fixedFrequencyEndType = this.reportPrepare.getFixedFrequencyEndType();
        int fixedFrequencyEndDate = this.reportPrepare.getFixedFrequencyEndDate();
        LocalTime fixedFrequencyEndTime = this.reportPrepare.getFixedFrequencyEndTime();
        CalendarDate calendarDate = new CalendarDate();
        for (ReportGeneratePeriod reportGeneratePeriod : reportGeneratePeriodList) {
            PeriodMember periodMember = reportGeneratePeriod.getPeriodMember();
            reportGeneratePeriod.setStartDate(calendarDate.getDate(periodMember.getStartDate(), fixedFrequencyStartType, frequencyStartDate));
            reportGeneratePeriod.setEndDate(calendarDate.getDate(periodMember.getStartDate(), fixedFrequencyEndType, fixedFrequencyEndDate, fixedFrequencyEndTime));
        }
        return reportGeneratePeriodList;
    }

    public static class CalendarDate {
        private Calendar calendar = Calendar.getInstance();

        public Date getDate(Date referDate, FixedFrequencyType fixedFrequencyType, int dayDate) {
            return this.getDate(referDate, fixedFrequencyType, dayDate, LocalTime.ofSecondOfDay(0L));
        }

        public Date getDate(Date referDate, FixedFrequencyType fixedFrequencyType, int dayDate, LocalTime localTime) {
            int calendarFieldType = fixedFrequencyType.getCalendarFieldType();
            int calendarDateFieldType = fixedFrequencyType.getCalendarDateFieldType();
            this.calendar.setTime(referDate);
            this.calendar.add(calendarFieldType, fixedFrequencyType.getDistanceCurrent());
            int expect = this.calendar.get(calendarFieldType);
            this.calendar.set(calendarDateFieldType, dayDate);
            int actual = this.calendar.get(calendarFieldType);
            if (expect != actual) {
                this.calendar.set(calendarDateFieldType, 1);
                this.calendar.add(calendarDateFieldType, -1);
            }
            Instant instant = this.calendar.getTime().toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate localDate = instant.atZone(zoneId).toLocalDate();
            LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
            return Date.from(localDateTime.atZone(zoneId).toInstant());
        }
    }
}

