/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.seqtask.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessServiceLifeCycleListener;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.property.TMCMQRecordProp;

public class MsgTaskFillTaskProcessServiceLifeCycleListenerImpl
implements TaskProcessServiceLifeCycleListener {
    private final List<TaskRecord> msgTaskRecordList = new ArrayList<TaskRecord>(16);

    @Override
    public void initialize(List<TaskRecord> taskRecordList) {
        ArrayList<Long> msgIdList = new ArrayList<Long>(16);
        for (TaskRecord taskRecord : taskRecordList) {
            Map<String, Object> taskParams = taskRecord.getTaskParams();
            String msgIdStr = StringHelper.getStringValue((Object)taskParams.get("msgId"));
            if (EmptyUtil.isEmpty((String)msgIdStr)) continue;
            msgIdList.add(Long.valueOf(msgIdStr));
            this.msgTaskRecordList.add(taskRecord);
        }
        if (EmptyUtil.isEmpty(msgIdList)) {
            return;
        }
        String selectFields = String.join((CharSequence)",", TMCMQRecordProp.HEAD_MSGINFO_TAG, "id");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tmc_mq_record", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", msgIdList)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
            return;
        }
        Map<String, String> msgContentMap = query.stream().collect(Collectors.toMap(dy -> dy.getLong("id") + "", dy -> dy.getString(TMCMQRecordProp.HEAD_MSGINFO_TAG), (a, b) -> a));
        for (TaskRecord taskRecord : this.msgTaskRecordList) {
            Map<String, Object> taskParams = taskRecord.getTaskParams();
            String msgIdStr = StringHelper.getStringValue((Object)taskParams.get("msgId"));
            String content = msgContentMap.get(msgIdStr);
            if (EmptyUtil.isEmpty((String)content)) continue;
            TaskRecord realTaskRecord = (TaskRecord)SerializationUtils.fromJsonString((String)content, TaskRecord.class);
            Map<String, Object> realTaskParams = realTaskRecord.getTaskParams();
            realTaskParams.put("msgId", msgIdStr);
            taskRecord.setTaskInfo(SerializationUtils.toJsonString(realTaskParams));
        }
    }

    @Override
    public void done() {
        for (TaskRecord taskRecord : this.msgTaskRecordList) {
            Map<String, Object> taskParams = taskRecord.getTaskParams();
            taskRecord.setTaskInfo(SerializationUtils.toJsonString(Collections.singletonMap("msgId", taskParams.get("msgId"))));
        }
    }
}

