/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.seqtask.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessServiceLifeCycleListener;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.RepeatTaskIgnoreTaskProcessServiceLifeCycleListenerImpl;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.ReportPlanIdempotenceAuditUnAuditListenerImpl;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.bean.FpmContext;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class ReportPlanAuditTaskProcessServiceImpl
implements TaskProcessService,
TaskProcessServiceLifeCycleListener {
    private final ReportBizService reportBizService = new ReportBizService();
    private final IDataSaveService dataSaveService = new DataSaveServiceImpl();

    @Override
    public void doProcess(TaskRecord taskRecord) {
        String taskInfo = taskRecord.getTaskInfo();
        Map params = (Map)SerializationUtils.fromJsonString((String)taskInfo, HashMap.class);
        String reportIdStr = StringHelper.getStringValue(params.get("reportPlanId"));
        FpmAssertUtil.isNotBlank((String)reportIdStr, (String)"reportId is empty.");
        String sumOrgId = StringHelper.getStringValue(params.get("sumOrgId"));
        FpmAssertUtil.isNotBlank((String)sumOrgId, (String)"sumOrgId is empty.");
        String subIdListStr = StringHelper.getStringValue(params.get("subIdList"));
        String[] split = StringHelper.split((String)subIdListStr, (String[])new String[0]);
        List<Long> subIdList = Arrays.stream(split).filter(EmptyUtil::isNoEmpty).map(Long::parseLong).collect(Collectors.toList());
        String periodIdStr = StringHelper.getStringValue(params.get("periodId"));
        FpmAssertUtil.isNotBlank((String)sumOrgId, (String)"periodId is empty.");
        FpmContext.get().put("periodId", (Object)Long.parseLong(periodIdStr));
        long reportId = Long.parseLong(reportIdStr);
        FpmOperateResult<Void> operateResult = this.reportBizService.auditReport(reportId, subIdList, Long.parseLong(sumOrgId), true);
        if (!operateResult.isSuccess()) {
            throw new KDBizException(String.join((CharSequence)";", CommonUtils.getOrDefault(operateResult.getMessageList(), new ArrayList(1))));
        }
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_report set fbillstatus=? where fid=?", Collections.singletonList(reportId), (t, d) -> {
            d.add(ReportProcessStatus.AUDIT.getValue());
            d.add(t);
        });
    }

    @Override
    public TaskType getTaskType() {
        return null;
    }

    @Override
    public void initialize(List<TaskRecord> taskRecordList) {
        if (EmptyUtil.isEmpty(taskRecordList)) {
            return;
        }
        TaskRecord taskRecord = taskRecordList.get(0);
        FpmContext fpmContext = FpmContext.get();
        Map<String, Object> params = taskRecord.getTaskParams();
        String systemIdStr = StringHelper.getStringValue((Object)params.get("systemId"));
        FpmAssertUtil.isNotBlank((String)systemIdStr, (String)"systemId is empty.");
        long systemId = Long.parseLong(systemIdStr);
        FundPlanSystem system = new DimensionRepository().loadSystem(systemId);
        fpmContext.put("fundSystem", (Object)system);
        Map dimMemberMap = system.getDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        fpmContext.put("dimMemberMap", dimMemberMap);
    }

    @Override
    public void done() {
        FpmContext.get().clear();
    }

    @Override
    public List<TaskProcessServiceLifeCycleListener> getTaskProcessServiceListeners() {
        return ListHelper.asList(this, new RepeatTaskIgnoreTaskProcessServiceLifeCycleListenerImpl(), new ReportPlanIdempotenceAuditUnAuditListenerImpl());
    }
}

