/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.seqtask.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.domain.enums.TaskStatus;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.service.IPlanChangeBizService;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateAsyncService;
import kd.tmc.fpm.business.mvc.service.calculate.impl.ReportCalculateAsyncServiceImpl;
import kd.tmc.fpm.business.mvc.service.impl.PlanChangeBizServiceImpl;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskProcessService;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class ReportPlanChangeSumTaskProcessServiceImpl
implements TaskProcessService {
    private IPlanChangeBizService planChangeBizService = new PlanChangeBizServiceImpl();
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private ReportCalculateAsyncService calculateAsyncService = new ReportCalculateAsyncServiceImpl();

    @Override
    public void doProcess(TaskRecord taskRecord) {
        String taskInfo = taskRecord.getTaskInfo();
        Map params = (Map)SerializationUtils.fromJsonString((String)taskInfo, HashMap.class);
        Object planChangeId = params.get("planChangeId");
        Object systemId = params.get("systemId");
        FpmAssertUtil.isNotNull(planChangeId, (String)"plan change id is null");
        FpmAssertUtil.isNotNull(systemId, (String)"systemId id is null");
        FpmOperateResult<Set<Long>> auditResult = this.planChangeBizService.audit(Long.parseLong(planChangeId.toString()));
        if (!auditResult.isSuccess()) {
            taskRecord.setStatus(TaskStatus.FAILED.name());
        } else {
            taskRecord.setStatus(TaskStatus.DONE.name());
        }
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(Long.parseLong(systemId.toString()));
        Set<Long> reportIds = auditResult.getData();
        if (CollectionUtils.isEmpty(reportIds)) {
            return;
        }
        this.calculateAsyncService.updateBeginEndSubjectRealAmount(planChangeId.toString(), reportIds, null, fundPlanSystem);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.REPORT_PLAN_CHANGE_TASK;
    }
}

