/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.seqtask.impl;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.mvc.repository.impl.TaskRecordRepository;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskHandleService;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class TaskHandleServiceImpl
implements TaskHandleService {
    private TaskRecordRepository taskRecordRepository = new TaskRecordRepository();

    @Override
    public void saveTask(TaskRecord task) {
        FpmAssertUtil.isNotNull((Object)task, (String)"task is null");
        FpmAssertUtil.isNotNull((Object)task.getTaskType(), (String)"task type is null");
        if (StringUtils.isEmpty((CharSequence)task.getName())) {
            TaskType taskType = TaskType.getByName(task.getTaskType());
            task.setName(Objects.nonNull((Object)taskType) ? taskType.getText() : "");
        }
        this.taskRecordRepository.saveTask(task);
    }

    @Override
    public void updateTask(TaskRecord task) {
        FpmAssertUtil.isNotNull((Object)task, (String)"task is null");
        FpmAssertUtil.isNotNull((Object)task.getId(), (String)"task id is null");
        FpmAssertUtil.isNotNull((Object)task.getTaskType(), (String)"task type is null");
        this.taskRecordRepository.updateTask(task);
    }

    @Override
    public void batchUpdateTask(List<TaskRecord> recordList) {
        FpmAssertUtil.isNotEmpty(recordList, (String)"recordList is empty");
        this.taskRecordRepository.batchUpdateTask(recordList);
    }

    @Override
    public void batchDeleteTaskByIds(List<Long> taskIdList) {
        FpmAssertUtil.isNotEmpty(taskIdList, (String)"taskIdList is empty");
        this.taskRecordRepository.batchDeleteTaskByIds(taskIdList);
    }

    @Override
    public void saveTaskIfNotRepeat(TaskRecord taskRecord) {
        Long objectId = taskRecord.getObjectId();
        if (EmptyUtil.isEmpty((Long)objectId)) {
            throw new KDBizException("objectId is empty");
        }
        if (this.taskRecordRepository.isRepeat(taskRecord.getObjectId(), taskRecord.getObjectEntityNumber())) {
            return;
        }
        this.taskRecordRepository.saveTask(taskRecord);
    }
}

