/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.seqtask.impl;

import java.util.List;
import java.util.Objects;
import kd.tmc.fpm.business.domain.enums.TaskStatus;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.mvc.repository.ITaskRecordRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TaskRecordRepository;
import kd.tmc.fpm.business.mvc.service.dto.TaskRecordQueryParamsDTO;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskRecordQueryService;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class TaskRecordQueryServiceImpl
implements TaskRecordQueryService {
    private ITaskRecordRepository taskRecordRepository = new TaskRecordRepository();

    @Override
    public TaskRecord loadSingleById(Long taskId) {
        FpmAssertUtil.isNotNull((Object)taskId, (String)"taskId is null");
        return this.taskRecordRepository.loadSingleById(taskId);
    }

    @Override
    public boolean existHandlingTask(String groupId, TaskType type) {
        FpmAssertUtil.isNotNull((Object)((Object)type), (String)"type is null");
        return this.taskRecordRepository.existByParam(null, TaskStatus.HANDLING.name(), type.name(), groupId);
    }

    @Override
    public List<TaskRecord> loadTaskByParams(TaskRecordQueryParamsDTO queryParamsDTO) {
        FpmAssertUtil.isNotNull((Object)queryParamsDTO, (String)"query param is null");
        String status = Objects.isNull((Object)queryParamsDTO.getStatus()) ? null : queryParamsDTO.getStatus().name();
        String taskType = Objects.isNull((Object)queryParamsDTO.getTaskType()) ? null : queryParamsDTO.getTaskType().name();
        return this.taskRecordRepository.loadTaskByParam(queryParamsDTO.getTaskId(), status, taskType, queryParamsDTO.getGroupId(), queryParamsDTO.getMaxSize(), queryParamsDTO.getOrderBy());
    }

    @Override
    public List<TaskRecord> load(List<Long> taskIds) {
        return this.taskRecordRepository.load(taskIds);
    }

    @Override
    public List<TaskRecord> loadTaskByParamsCompatible(TaskRecordQueryParamsDTO queryParamsDTO) {
        return this.taskRecordRepository.loadTaskByParamsCompatible(queryParamsDTO);
    }
}

