/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.strategy;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.BillState;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.SourceIdQueryParam;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ReportDataGetSourceIdStrategy {
    private IReportRepository iReportRepository = FpmServiceFactory.getBizService(IReportRepository.class);
    private IDimensionRepository iDimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);
    private IReportDataQueryService iReportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
    private ISumPlanRepository iSumPlanRepository = FpmServiceFactory.getBizService(ISumPlanRepository.class);
    private ISummaryConfigService iSummaryConfigService = FpmServiceFactory.getBizService(ISummaryConfigService.class);
    private TemplateUseType templateUseType;
    private boolean mainTable;
    private TemplateType templateType;
    private List<ReportData> reportDataList;
    private FundPlanSystem fundPlanSystem;
    private Long reportId;
    private Long reportOrgId;
    private Long reportPeriodId;
    private SumPlanParamConfig sumPlanParamConfig;

    public ReportDataGetSourceIdStrategy(SourceIdQueryParam queryParam) {
        this.templateUseType = queryParam.getTemplateUseType();
        this.templateType = queryParam.getTemplateType();
        this.reportDataList = queryParam.getReportDataList();
        this.reportId = queryParam.getReportId();
        if (queryParam.getTemplateUseType() == TemplateUseType.PLANING) {
            this.mainTable = queryParam.isMainTable();
        }
        if (this.templateType == TemplateType.FIXED) {
            this.fundPlanSystem = this.iDimensionRepository.loadSystem(queryParam.getSystemId());
        }
        if (queryParam.getTemplateUseType() == TemplateUseType.ANALYSIS || queryParam.getTemplateUseType() == TemplateUseType.SUMMARY) {
            this.reportOrgId = queryParam.getReportOrgId();
            this.reportPeriodId = queryParam.getReportPeriodId();
        }
        if (queryParam.getTemplateUseType() == TemplateUseType.ANALYSIS || queryParam.getTemplateUseType() == TemplateUseType.SUMMARY) {
            this.sumPlanParamConfig = this.iSummaryConfigService.getSummaryParamConfig(this.reportId);
            FpmAssertUtil.isNotNull((Object)this.sumPlanParamConfig, (String)ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u3002", (String)"AnalysisReportBizService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }

    public List<Long> getSourceIds() {
        switch (this.templateUseType) {
            case PLANING: {
                return this.getSourceIdForReportPlan();
            }
            case SUMMARY: 
            case ANALYSIS: {
                return this.getSourceIdForSumPlan();
            }
        }
        return new ArrayList<Long>(0);
    }

    private List<Long> getSourceIds(List<ReportDataQueryResult> leafReportDataList) {
        if (CollectionUtils.isEmpty(leafReportDataList)) {
            return new ArrayList<Long>(0);
        }
        return leafReportDataList.stream().map(ReportDataQueryResult::getSourceIdList).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private List<ReportDataQueryResult> getReportDataByReportDataIds() {
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        queryObject.setIdList(this.reportDataList.stream().map(ReportData::getId).collect(Collectors.toList()));
        ArrayList<Long> reportIds = new ArrayList<Long>(1);
        reportIds.add(this.reportId);
        queryObject.setReportIdS(reportIds);
        return this.iReportDataQueryService.queryReportData(queryObject);
    }

    private List<ReportDataQueryResult> getReportDataForReportPlan(List<Long> reportIds, Supplier<List<Object>> subjectDimValSupplier) {
        ArrayList<Dimension> dimIdList = new ArrayList<Dimension>(10);
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(10);
        for (Dimension dimension : this.fundPlanSystem.getMainDimList()) {
            OptionalInt dimIdxOpt;
            if (dimension.getDimType() != DimensionType.SUBJECTS && dimension.getDimType() != DimensionType.PERIOD && dimension.getDimType() != DimensionType.ORG && dimension.getDimType() != DimensionType.CURRENCY && dimension.getDimType() != DimensionType.COMPANY && dimension.getDimType() != DimensionType.SETTLEMENT_TYPE && dimension.getDimType() != DimensionType.CUSTOM || !(dimIdxOpt = IntStream.range(0, this.reportDataList.get(0).getDimList().size()).filter(i -> Objects.equals(this.reportDataList.get(0).getDimList().get(i).getDimensionId(), dimension.getId())).findAny()).isPresent()) continue;
            Set paramDimValList = this.reportDataList.stream().map(reportData -> reportData.getDimValList().get(dimIdxOpt.getAsInt())).collect(Collectors.toSet());
            List<Object> memberScopeList = Objects.nonNull(subjectDimValSupplier) && dimension.getDimType() == DimensionType.SUBJECTS ? subjectDimValSupplier.get() : new ArrayList(paramDimValList);
            dimIdList.add(dimension);
            dimValList.add(memberScopeList);
        }
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        queryObject.setDimIdList(dimIdList);
        queryObject.setDimValList(dimValList);
        queryObject.setReportIdS(reportIds);
        return this.iReportDataQueryService.queryReportData(queryObject);
    }

    private List<Long> getSourceIdForReportPlan() {
        if (!this.mainTable && Objects.nonNull((Object)this.templateType) && this.templateType.isDetail()) {
            return this.getSourceIds(this.getReportDataByReportDataIds());
        }
        ReportNeedPropDTO reportNeedPropDTO = new ReportNeedPropDTO();
        reportNeedPropDTO.setNeedTemplate(true);
        HashSet<Long> reportIdSet = new HashSet<Long>(2, 1.0f);
        reportIdSet.add(this.reportId);
        List<Report> simpleReportList = this.iReportRepository.loadSimpleReport(reportIdSet, reportNeedPropDTO);
        Report report = simpleReportList.get(0);
        Dimension subjectDimension = this.fundPlanSystem.getMainDimList().stream().filter(dimension -> dimension.getDimType() == DimensionType.SUBJECTS).findAny().get();
        int subjectDimIdx = IntStream.range(0, this.reportDataList.get(0).getDimList().size()).filter(i -> Objects.equals(subjectDimension.getId(), this.reportDataList.get(0).getDimList().get(i).getDimensionId())).findAny().getAsInt();
        Set<Long> selectedSubjectMemberIds = this.reportDataList.stream().map(reportData -> reportData.getDimValList().get(subjectDimIdx)).map(o -> (Long)o).collect(Collectors.toSet());
        ArrayList leafSubjectIdList = new ArrayList(0);
        selectedSubjectMemberIds.forEach(memberId -> subjectDimension.getAllDimMemberList().stream().filter(member -> Objects.equals(member.getId(), memberId)).filter(member -> !member.isLeaf() && report.getInitFlag() != false).map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).filter(id -> !selectedSubjectMemberIds.contains(id)).forEach(leafSubjectIdList::add));
        selectedSubjectMemberIds.addAll(leafSubjectIdList);
        List detailInputSubjectMemberList = report.getTemplate().getAccountSettings().stream().filter(setting -> setting.getInputType() == ReportInputType.DETAIL_INPUT).map(TemplateAccountSetting::getAccountMemId).filter(selectedSubjectMemberIds::contains).collect(Collectors.toList());
        List manualInputSubjectMemberList = report.getTemplate().getAccountSettings().stream().filter(setting -> setting.getInputType() == ReportInputType.MANUAL_INPUT).map(TemplateAccountSetting::getAccountMemId).filter(selectedSubjectMemberIds::contains).collect(Collectors.toList());
        List<Long> reportIds = Collections.singletonList(this.reportId);
        HashSet<Long> sourceIdSet = new HashSet<Long>(16);
        if (CollectionUtils.isNotEmpty(detailInputSubjectMemberList)) {
            List<Long> subReportIds = this.iReportRepository.querySubReportId(reportIds);
            List<ReportDataQueryResult> subReportDataList = this.getReportDataForReportPlan(subReportIds, () -> new ArrayList(detailInputSubjectMemberList));
            sourceIdSet.addAll(this.findSourceIdsByPerReportDataDimCombination(subReportDataList));
        }
        if (CollectionUtils.isNotEmpty(manualInputSubjectMemberList)) {
            List<ReportDataQueryResult> mainReportDataList = this.getReportDataForReportPlan(reportIds, () -> new ArrayList(manualInputSubjectMemberList));
            sourceIdSet.addAll(this.findSourceIdsByPerReportDataDimCombination(mainReportDataList));
        }
        return new ArrayList<Long>(sourceIdSet);
    }

    private List<Long> getSourceIdForSumPlan() {
        ArrayList<Dimension> dimIdList = new ArrayList<Dimension>(10);
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(10);
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        for (Dimension dimension : this.fundPlanSystem.getMainDimList()) {
            OptionalInt dimIdxOpt;
            if (dimension.getDimType() != DimensionType.SUBJECTS && dimension.getDimType() != DimensionType.PERIOD && dimension.getDimType() != DimensionType.ORG && dimension.getDimType() != DimensionType.CURRENCY && dimension.getDimType() != DimensionType.COMPANY && dimension.getDimType() != DimensionType.SETTLEMENT_TYPE && dimension.getDimType() != DimensionType.CUSTOM || !(dimIdxOpt = IntStream.range(0, this.reportDataList.get(0).getDimList().size()).filter(i -> Objects.equals(this.reportDataList.get(0).getDimList().get(i).getDimensionId(), dimension.getId())).findAny()).isPresent()) continue;
            Set<Long> paramDimValSet = this.reportDataList.stream().map(reportData -> reportData.getDimValList().get(dimIdxOpt.getAsInt())).map(o -> (Long)o).collect(Collectors.toSet());
            ArrayList<Object> memberScopeList = new ArrayList(paramDimValSet);
            if (dimension.getDimType() == DimensionType.SUBJECTS) {
                dimension.getAllDimMemberList().stream().filter(member -> paramDimValSet.contains(member.getId())).filter(member -> !member.isLeaf()).map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).forEach(memberScopeList::add);
            }
            if (dimension.getDimType() == DimensionType.ORG) {
                List<Long> leafReportOrgList = this.getLeafReportOrgList4SumPlan(paramDimValSet);
                queryObject.setReportOrgIds(leafReportOrgList);
                memberScopeList = new ArrayList<Long>(leafReportOrgList);
            }
            dimIdList.add(dimension);
            dimValList.add(memberScopeList);
        }
        queryObject.setReportIdS(this.getLeafAuditedReportPlanIds4SumPlan(queryObject.getReportOrgIds()));
        if (EmptyUtil.isEmpty(queryObject.getReportIdS())) {
            return new ArrayList<Long>(0);
        }
        queryObject.setDimIdList(dimIdList);
        queryObject.setDimValList(dimValList);
        queryObject.setReportPlanType(ReportPlanType.REPORTPLAN);
        queryObject.setReportPeriodId(this.reportPeriodId);
        List<ReportDataQueryResult> lowerLevelReportDataQueryResult = this.iReportDataQueryService.queryReportData(queryObject);
        return new ArrayList<Long>(this.findSourceIdsByPerReportDataDimCombination(lowerLevelReportDataQueryResult));
    }

    private Set<Long> findSourceIdsByPerReportDataDimCombination(List<ReportDataQueryResult> queryResults) {
        List warpBeanList = queryResults.stream().map(item -> {
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(item.getDimList(), item.getDimValList(), rd -> !rd.getDimType().isVirtualDim());
            return new WarpBean<String, ReportDataQueryResult>(UUID.randomUUID().toString(), dimensionInfoBean, (ReportDataQueryResult)item);
        }).collect(Collectors.toList());
        QueryIndexInfo queryIndexInfo = QueryIndexInfoMapGenerator.build(warpBeanList, this.fundPlanSystem, rd -> true);
        Long orgDimId = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.ORG).getId();
        Long subjectDimId = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS).getId();
        Predicate<TemplateDim> predicate = templateDim -> !templateDim.getDimensionId().equals(orgDimId) && !templateDim.getDimensionId().equals(subjectDimId);
        HashSet<Long> sourceIdSet = new HashSet<Long>(16);
        for (ReportData reportData : this.reportDataList) {
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData.getDimList(), reportData.getDimValList(), predicate);
            List<ReportDataQueryResult> currDimCombinationQueryResults = queryIndexInfo.findList(dimensionInfoBean);
            currDimCombinationQueryResults.stream().map(ReportDataQueryResult::getSourceIdList).filter(Objects::nonNull).forEach(sourceIdSet::addAll);
        }
        return sourceIdSet;
    }

    private List<Long> getLeafReportOrgList4SumPlan(Set<Long> paramDimValSet) {
        List allChildConfigInfoList = this.sumPlanParamConfig.getConfigInfoList().stream().filter(item -> item.getOrgMemberId().equals(this.reportOrgId)).map(SumPlanParamConfigInfo::getAllChildren).flatMap(Collection::stream).collect(Collectors.toList());
        Map allChildConfigInfoMap = allChildConfigInfoList.stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> a));
        Set<Long> allChildSumReportOrgSet = allChildConfigInfoList.stream().filter(SumPlanParamConfigInfo::isSumAuditNode).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
        List<SumPlanRecord> allChildSumReportList = this.iSumPlanRepository.loadSumPlanRecord(allChildSumReportOrgSet, this.reportPeriodId);
        Set allChildAuditSumReportOrgSet = allChildSumReportList.stream().filter(sumPlanRecord -> BillStatus.AUDITED == sumPlanRecord.getStatus()).map(SumPlanRecord::getReportOrg).collect(Collectors.toSet());
        ArrayList<Long> leafReportOrgList = new ArrayList<Long>(allChildConfigInfoList.size() - allChildSumReportOrgSet.size());
        block0: for (SumPlanParamConfigInfo childConfigInfo : allChildConfigInfoList) {
            if (!paramDimValSet.contains(this.reportOrgId) && !paramDimValSet.contains(childConfigInfo.getOrgMemberId()) || childConfigInfo.isSumAuditNode()) continue;
            ArrayDeque<Long> stack = new ArrayDeque<Long>(1);
            Long parentOrgId = childConfigInfo.getParentId();
            stack.push(parentOrgId);
            while (!stack.isEmpty()) {
                Long currParentOrgId = (Long)stack.pop();
                if (Objects.equals(this.reportOrgId, currParentOrgId)) {
                    leafReportOrgList.add(childConfigInfo.getOrgMemberId());
                    continue block0;
                }
                if (allChildSumReportOrgSet.contains(currParentOrgId)) {
                    if (!allChildAuditSumReportOrgSet.contains(currParentOrgId)) continue block0;
                    leafReportOrgList.add(childConfigInfo.getOrgMemberId());
                    continue block0;
                }
                Long nextParentOrgId = allChildConfigInfoMap.containsKey(currParentOrgId) ? ((SumPlanParamConfigInfo)allChildConfigInfoMap.get(currParentOrgId)).getParentId() : 0L;
                if (EmptyUtil.isEmpty((Long)nextParentOrgId)) continue block0;
                stack.push(nextParentOrgId);
            }
        }
        return leafReportOrgList;
    }

    private List<Long> getLeafAuditedReportPlanIds4SumPlan(List<Long> leafReportOrgList) {
        String isMainTableProp = String.join((CharSequence)".", "templatebak", "ismaintable");
        String templateBakIdProp = String.join((CharSequence)".", "templatebak", "templateid");
        String reportOrgIdProp = String.join((CharSequence)".", "reportorg", "id");
        String parentTemplateIdProp = String.join((CharSequence)".", "parenttemplate", "id");
        String reportPeriodIdProp = String.join((CharSequence)".", "reportperiod", "id");
        List<String> props = Arrays.asList(reportOrgIdProp, reportPeriodIdProp, templateBakIdProp, parentTemplateIdProp, isMainTableProp, "id");
        QFilter qFilter = new QFilter("bodysys", "=", (Object)this.fundPlanSystem.getId()).and("reportperiod", "=", (Object)this.reportPeriodId).and("reportorg", "in", leafReportOrgList).and("reportplantype", "=", (Object)ReportPlanType.REPORTPLAN.getNumber()).and("billstatus", "=", (Object)BillState.AUDITED.getNumber());
        DynamicObjectCollection reportDyColl = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", props), (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)reportDyColl)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> auditReportPlanIds = new ArrayList<Long>(reportDyColl.size());
        HashMap auditedMainReportMap = new HashMap(8);
        reportDyColl.stream().filter(reportDy -> reportDy.getBoolean(isMainTableProp)).forEach(reportDy -> {
            Long reportId = reportDy.getLong("id");
            auditedMainReportMap.put(reportId, reportDy);
            auditReportPlanIds.add(reportId);
        });
        for (DynamicObject reportDy2 : reportDyColl) {
            Long reportId = reportDy2.getLong("id");
            if (auditedMainReportMap.containsKey(reportId)) continue;
            Long subReportOrgId = reportDy2.getLong(reportOrgIdProp);
            Long parentTemplateId = reportDy2.getLong(parentTemplateIdProp);
            Long subReportPeriodId = reportDy2.getLong(reportPeriodIdProp);
            boolean existSubReportAssocAuditedMainTable = auditedMainReportMap.values().stream().anyMatch(mainReportDy -> {
                Long templateBakId = mainReportDy.getLong(templateBakIdProp);
                Long mainReportOrgId = mainReportDy.getLong(reportOrgIdProp);
                Long mainReportPeriodId = mainReportDy.getLong(reportPeriodIdProp);
                return Objects.equals(mainReportOrgId, subReportOrgId) && Objects.equals(mainReportPeriodId, subReportPeriodId) && Objects.equals(parentTemplateId, templateBakId);
            });
            if (!existSubReportAssocAuditedMainTable) continue;
            auditReportPlanIds.add(reportId);
        }
        return auditReportPlanIds;
    }
}

