/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.upgrade;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.common.enums.DimsionEnums;
import org.apache.commons.collections.CollectionUtils;

public class CurrencyNameUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(CurrencyNameUpgradeServiceImpl.class);

    @Override
    public void updateData() {
        logger.info("[CurrencyNameUpgradeServiceImpl] >>>> \u5e01\u522b\u540d\u79f0\u5347\u7ea7\u4e3a\u5e01\u79cd\u4efb\u52a1\u5f00\u59cb... ");
        String selectProp = String.join((CharSequence)",", "id", "name", "basedata");
        DynamicObject[] currencyDims = BusinessDataServiceHelper.load((String)"fpm_dimension", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("basedata", "=", (Object)DimsionEnums.CURRENCY.getNumber())});
        if (currencyDims == null || currencyDims.length == 0) {
            logger.info("[CurrencyNameUpgradeServiceImpl] >>>> \u5e01\u522b\u540d\u79f0\u5347\u7ea7\u4e3a\u5e01\u79cd\u4efb\u52a1\u7ed3\u675f, \u5f53\u524d\u5e01\u522b\u7ef4\u5ea6\u4e3a\u7a7a ");
            return;
        }
        ArrayList<DynamicObject> needUpdate = new ArrayList<DynamicObject>(currencyDims.length);
        for (DynamicObject currencyDim : currencyDims) {
            ILocaleString localeString = currencyDim.getLocaleString("name");
            if (localeString == null) continue;
            String zhCnValue = localeString.getLocaleValue_zh_CN();
            if (!StringUtils.equals((CharSequence)this.getStringOldName(), (CharSequence)zhCnValue)) continue;
            currencyDim.set("name", (Object)new LocaleString(Lang.zh_CN.toString(), this.getNewName()));
            needUpdate.add(currencyDim);
        }
        if (CollectionUtils.isNotEmpty(needUpdate)) {
            SaveServiceHelper.update((DynamicObject[])needUpdate.toArray(new DynamicObject[0]));
        }
        logger.info("[CurrencyNameUpgradeServiceImpl] >>>> \u5e01\u522b\u540d\u79f0\u5347\u7ea7\u4e3a\u5e01\u79cd\u4efb\u52a1\u7ed3\u675f. \u5171\u8ba1\u5904\u7406\u6570\u636e\uff1a{}\u6761 ", (Object)needUpdate.size());
    }

    private String getStringOldName() {
        return ResManager.loadKDString((String)"\u5e01\u522b", (String)"CurrencyNameUpgradeServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
    }

    private String getNewName() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CurrencyNameUpgradeServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
    }
}

