/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.upgrade;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.SunReportSumStatus;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.service.sumreport.service.impl.SummaryConfigServiceImpl;
import org.apache.commons.lang3.tuple.MutablePair;

public class SummaryConfigSnapshotInitialUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SummaryConfigSnapshotInitialUpgradeServiceImpl.class);
    private ISummaryConfigService iSummaryConfigService = new SummaryConfigServiceImpl();
    private static final int DEFAULT_SYSTEM_PAGE_SIZE = 5;
    private static final int DEFAULT_PERIOD_PAGE_SIZE = 50;
    private int upgradeReportSize = 0;
    private int initialSnapshotSize = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateData() {
        block22: {
            long beginTime = System.currentTimeMillis();
            boolean withExc = false;
            try (TXHandle tx = TX.requiresNew();){
                long endTime;
                try {
                    logger.info("SummaryConfigSnapshotInitialUpgradeServiceImpl start upgrade...");
                    this.initialSummaryConfigSnapshot();
                    logger.info("SummaryConfigSnapshotInitialUpgradeServiceImpl end upgrade...");
                }
                catch (Exception e) {
                    try {
                        withExc = true;
                        logger.error(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        long endTime2 = System.currentTimeMillis();
                        if (withExc) {
                            logger.info(String.format("SummaryConfigSnapshotInitialUpgradeServiceImpl Exception take up time \uff1a%sms", endTime2 - beginTime));
                        } else {
                            logger.info(String.format("SummaryConfigSnapshotInitialUpgradeServiceImpl no Exception take up time \uff1a%sms", endTime2 - beginTime));
                        }
                        throw throwable;
                    }
                    endTime = System.currentTimeMillis();
                    if (withExc) {
                        logger.info(String.format("SummaryConfigSnapshotInitialUpgradeServiceImpl Exception take up time \uff1a%sms", endTime - beginTime));
                    } else {
                        logger.info(String.format("SummaryConfigSnapshotInitialUpgradeServiceImpl no Exception take up time \uff1a%sms", endTime - beginTime));
                    }
                    break block22;
                }
                endTime = System.currentTimeMillis();
                if (withExc) {
                    logger.info(String.format("SummaryConfigSnapshotInitialUpgradeServiceImpl Exception take up time \uff1a%sms", endTime - beginTime));
                } else {
                    logger.info(String.format("SummaryConfigSnapshotInitialUpgradeServiceImpl no Exception take up time \uff1a%sms", endTime - beginTime));
                }
            }
        }
    }

    public void initialSummaryConfigSnapshot() {
        Long lastSystemId = 0L;
        String entryReportTypeIdProp = "applyrereportentry.rerporttype.id";
        String entryReportTypeStatusProp = "applyrereportentry.rereporttypestatus";
        block0: while (true) {
            QFilter pageFilter = new QFilter("id", ">", (Object)lastSystemId);
            QFilter qFilter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
            DynamicObjectCollection systemDyColl = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)"id", (QFilter[])new QFilter[]{pageFilter, qFilter}, (String)"id", (int)5);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)systemDyColl)) break;
            lastSystemId = ((DynamicObject)systemDyColl.get(systemDyColl.size() - 1)).getLong("id");
            List systemIdList = systemDyColl.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            qFilter = new QFilter("id", "in", systemIdList).and(entryReportTypeStatusProp, "=", (Object)BaseEnableEnum.ENABLE.name().toLowerCase());
            systemDyColl = QueryServiceHelper.query((String)"fpm_bodysysmanage", (String)String.join((CharSequence)",", "id", entryReportTypeIdProp), (QFilter[])qFilter.toArray(), (String)"id");
            Iterator iterator = systemDyColl.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                DynamicObject systemDy = (DynamicObject)iterator.next();
                Long systemId = systemDy.getLong("id");
                Long reportTypeId = systemDy.getLong(entryReportTypeIdProp);
                HashMap sumPlanParamConfigMap = Maps.newHashMapWithExpectedSize((int)8);
                HashMap config2SnapshotMap = Maps.newHashMapWithExpectedSize((int)8);
                this.initialSnapshotByPerPeriod(systemId, reportTypeId, sumPlanParamConfigMap, config2SnapshotMap);
                this.initialSnapshotSize += config2SnapshotMap.size();
            }
            break;
        }
        logger.info("\u6c47\u603b\u53c2\u6570\u5feb\u7167\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u521d\u59cb\u5316\u5feb\u7167\u6570\u91cf\uff1a{}\uff0c\u540c\u6b65\u62a5\u8868\u6570\u91cf\uff1a{}", (Object)this.initialSnapshotSize, (Object)this.upgradeReportSize);
    }

    private void initialSnapshotByPerPeriod(Long systemId, Long reportTypeId, Map<String, List<SumPlanParamConfig>> sumPlanParamConfigMap, Map<Long, Long> config2SnapshotMap) {
        Long lastPeriodMemberId = 0L;
        block0: while (true) {
            QFilter pageFilter = new QFilter("id", ">", (Object)lastPeriodMemberId);
            QFilter qFilter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()).and("dimtype", "=", (Object)DimensionType.PERIOD.getNumber()).and("bodysystem", "=", (Object)systemId).and("reporttype", "=", (Object)reportTypeId);
            DynamicObjectCollection periodMemberDyColl = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{pageFilter, qFilter}, (String)"id", (int)50);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)periodMemberDyColl)) {
                return;
            }
            lastPeriodMemberId = ((DynamicObject)periodMemberDyColl.get(periodMemberDyColl.size() - 1)).getLong("id");
            Iterator iterator = periodMemberDyColl.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                DynamicObject periodMemberDy = (DynamicObject)iterator.next();
                Long periodMemberId = periodMemberDy.getLong("id");
                this.initialSnapshotBySameBatchReport(systemId, reportTypeId, periodMemberId, sumPlanParamConfigMap, config2SnapshotMap);
            }
            break;
        }
    }

    private void initialSnapshotBySameBatchReport(Long systemId, Long reportTypeId, Long reportPeriodId, Map<String, List<SumPlanParamConfig>> sumPlanParamConfigMap, Map<Long, Long> config2SnapshotMap) {
        String sumEntrySumOrgReportIdProp = "sumentry.sumorgreportid";
        String sumEntrySumStatusProp = "sumentry.sumstatus";
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId).and("reportperiod", "=", (Object)reportPeriodId);
        DynamicObjectCollection reportDyColl = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", "id", "planstatus", "reportorg.id", "reportplantype", "summaryconfigsnp", sumEntrySumOrgReportIdProp, sumEntrySumStatusProp), (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)reportDyColl)) {
            return;
        }
        boolean noneExistEnableReport = reportDyColl.stream().map(dy -> dy.getString("planstatus")).noneMatch(planStatus -> Objects.equals(ReportStatus.ENABLE.getVal(), planStatus));
        if (noneExistEnableReport) {
            return;
        }
        boolean allEnableReportExistSnapshot = reportDyColl.stream().filter(dy -> Objects.equals(ReportStatus.ENABLE.getVal(), dy.getString("planstatus"))).map(dy -> dy.getLong("summaryconfigsnp")).allMatch(EmptyUtil::isNoEmpty);
        if (allEnableReportExistSnapshot) {
            return;
        }
        String mapKey = systemId + "#" + reportTypeId;
        List sumPlanParamConfigList = sumPlanParamConfigMap.computeIfAbsent(mapKey, val -> this.iSummaryConfigService.loadSumConfigBySystems(Collections.singletonList(systemId), Collections.singletonList(reportTypeId)));
        if (EmptyUtil.isEmpty((Collection)sumPlanParamConfigList)) {
            return;
        }
        Map<Long, Long> report2OrgMap = reportDyColl.stream().collect(Collectors.toMap(key -> key.getLong("id"), val -> val.getLong("reportorg.id"), (a, b) -> a));
        Set sumReportOrgSet = reportDyColl.stream().filter(dy -> Objects.equals(ReportPlanType.SUMPLAN.getNumber(), dy.getString("reportplantype"))).map(dy -> dy.getLong("reportorg.id")).collect(Collectors.toSet());
        Set planReportOrgSet = reportDyColl.stream().filter(dy -> Objects.equals(ReportPlanType.REPORTPLAN.getNumber(), dy.getString("reportplantype"))).map(dy -> dy.getLong("reportorg.id")).collect(Collectors.toSet());
        Set upperSumReportIdSet = reportDyColl.stream().filter(dy -> Objects.equals(ReportPlanType.SUMPLAN.getNumber(), dy.getString("reportplantype"))).filter(dy -> Objects.equals(SunReportSumStatus.SUM.getNumber(), dy.getString(sumEntrySumStatusProp))).map(dy -> dy.getLong(sumEntrySumOrgReportIdProp)).collect(Collectors.toSet());
        PriorityQueue<MutablePair> matchingDegreePQ = new PriorityQueue<MutablePair>(sumPlanParamConfigList.size(), (a, b) -> {
            int degree = (Integer)b.getRight() - (Integer)a.getRight();
            if (degree != 0) {
                return degree;
            }
            if (((SumPlanParamConfig)b.getLeft()).isEnable() && !((SumPlanParamConfig)a.getLeft()).isEnable()) {
                return 1;
            }
            if (((SumPlanParamConfig)a.getLeft()).isEnable() && !((SumPlanParamConfig)b.getLeft()).isEnable()) {
                return -1;
            }
            return ((SumPlanParamConfig)b.getLeft()).getId().compareTo(((SumPlanParamConfig)a.getLeft()).getId());
        });
        for (SumPlanParamConfig sumPlanParamConfig : sumPlanParamConfigList) {
            MutablePair pair;
            int degree = 0;
            Map configInfoMap = sumPlanParamConfig.getConfigInfoList().stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> a));
            boolean allSumReportOrgInConfig = sumReportOrgSet.stream().allMatch(orgId -> configInfoMap.containsKey(orgId) && ((SumPlanParamConfigInfo)configInfoMap.get(orgId)).isSumAuditNode());
            if (!allSumReportOrgInConfig) {
                MutablePair pair2 = MutablePair.of((Object)sumPlanParamConfig, (Object)degree);
                matchingDegreePQ.offer(pair2);
                continue;
            }
            ++degree;
            boolean upperSumReportOrgAllInConfig = upperSumReportIdSet.stream().map(report2OrgMap::get).allMatch(orgId -> Objects.nonNull(orgId) && configInfoMap.containsKey(orgId));
            if (!upperSumReportOrgAllInConfig) {
                MutablePair pair3 = MutablePair.of((Object)sumPlanParamConfig, (Object)degree);
                matchingDegreePQ.offer(pair3);
                continue;
            }
            ++degree;
            boolean allPlanReportOrgInConfig = planReportOrgSet.stream().allMatch(orgId -> configInfoMap.containsKey(orgId) && !((SumPlanParamConfigInfo)configInfoMap.get(orgId)).isSumAuditNode());
            if (!allPlanReportOrgInConfig) {
                MutablePair pair4 = MutablePair.of((Object)sumPlanParamConfig, (Object)degree);
                matchingDegreePQ.offer(pair4);
                continue;
            }
            ++degree;
            boolean allConfigSumReportOrgInReport = configInfoMap.keySet().stream().filter(orgId -> ((SumPlanParamConfigInfo)configInfoMap.get(orgId)).isSumAuditNode()).allMatch(sumReportOrgSet::contains);
            if (!allConfigSumReportOrgInReport) {
                pair = MutablePair.of((Object)sumPlanParamConfig, (Object)degree);
                matchingDegreePQ.offer(pair);
                continue;
            }
            pair = MutablePair.of((Object)sumPlanParamConfig, (Object)(++degree));
            matchingDegreePQ.offer(pair);
        }
        SumPlanParamConfig matchedConfig = (SumPlanParamConfig)((MutablePair)matchingDegreePQ.peek()).getLeft();
        Long snapshotId = config2SnapshotMap.computeIfAbsent(matchedConfig.getId(), val -> this.iSummaryConfigService.generateSnapshot(matchedConfig));
        Set<Long> reportIdSet = report2OrgMap.keySet();
        this.iSummaryConfigService.syncSnapshotToReport(snapshotId, reportIdSet);
        this.upgradeReportSize += reportIdSet.size();
    }
}

