/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.basesetting;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fpm.business.mq.TMCMQPublisher;
import kd.tmc.fpm.business.mq.TMCMQSendDTO;
import kd.tmc.fpm.common.enums.MQBusinessTypeEnum;

public class ReportPreparationGenMqService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("fixedfrequency");
        selector.add("bodysysmanage");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long id = (Long)dynamicObject.get("id");
            if (dynamicObject.getBoolean("fixedfrequency")) {
                String content = SerializationUtils.toJsonString(Collections.singletonMap("reportPrepareId", id.toString()));
                this.publishGenReport(content, MQBusinessTypeEnum.GEN_FIXED_FREQ_REPORT);
            } else {
                this.publishGenReport(id, MQBusinessTypeEnum.GEN_REPORT);
            }
            this.operationResult.setMessage(ResManager.loadKDString((String)"\u5df2\u5f00\u59cb\u6267\u884c\u751f\u6210\u8d44\u91d1\u8ba1\u5212\u5355\u636e\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u3002", (String)"ReportPreparationGenMqService_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }

    private void publishGenReport(Object content, MQBusinessTypeEnum mqBusinessTypeEnum) {
        TMCMQPublisher tmcmqPublisher = new TMCMQPublisher();
        TMCMQSendDTO tmcmqSendDTO = new TMCMQSendDTO();
        tmcmqSendDTO.setAppId("fpm");
        tmcmqSendDTO.setBusinessType(mqBusinessTypeEnum);
        tmcmqSendDTO.setMsgContent(content);
        tmcmqSendDTO.setTopicName("fpm.fpm_queue");
        tmcmqPublisher.sendMsg(tmcmqSendDTO);
    }
}

