/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.basesetting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.service.gather.FpmCollectService;
import kd.tmc.fpm.business.service.ie.gather.service.gather.impl.ManualCollectStrategy;

public class StartIntelligentGatherService
extends AbstractTmcBizOppService {
    private static final String HEAD_SOURCEBILL = "sourcebill";
    private static final String HEAD_ORGRANGE = "orgrange";
    private static final String COLLECT_TYPE = "collecttype";
    private static final int COLLECT_TYPE_ENTIRE = 2;
    private String schemeId = null;

    public StartIntelligentGatherService(String schemeId) {
        this.schemeId = schemeId;
    }

    public List<String> getSelector() {
        List seletor = super.getSelector();
        seletor.add(HEAD_SOURCEBILL);
        seletor.add(HEAD_ORGRANGE);
        return seletor;
    }

    public void process(DynamicObject[] dataEntitys) throws KDException {
        for (DynamicObject dataEntity : dataEntitys) {
            String sourceBill = dataEntity.getDynamicObject(HEAD_SOURCEBILL).getString("number");
            HashSet<Object> schemeIds = new HashSet<Object>(1);
            if (EmptyUtil.isEmpty((String)this.schemeId)) {
                QFilter filter = new QFilter("enable", "=", (Object)"1");
                filter.and(new QFilter(HEAD_SOURCEBILL, "=", (Object)sourceBill));
                DynamicObject[] smartCollectPlans = TmcDataServiceHelper.load((String)"fpm_smartcollect", (String)String.format("%s,%s", "name", "id"), (QFilter[])new QFilter[]{filter});
                Set ids = Arrays.stream(smartCollectPlans).filter(Objects::nonNull).map(smartColPlan -> smartColPlan.getLong("id")).collect(Collectors.toSet());
                schemeIds.addAll(ids);
            } else {
                schemeIds.add(Long.valueOf(this.schemeId));
            }
            boolean entireCollect = dataEntity.getInt(COLLECT_TYPE) == 2;
            DynamicObjectCollection orgDys = dataEntity.getDynamicObjectCollection(HEAD_ORGRANGE);
            Set orgs = orgDys.stream().filter(Objects::nonNull).map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toSet());
            ThreadPools.executeOnce((String)this.getThreadName(sourceBill), () -> {
                FpmCollectService service = new FpmCollectService(new ArrayList<Long>(schemeIds), new ManualCollectStrategy(orgs));
                service.collect(entireCollect);
            });
        }
    }

    private String getThreadName(String sourceBill) {
        return String.format("%s-bill-intelligent-gather-%s", sourceBill, DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyyMMddHHmmss"}));
    }
}

