/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.execbiasanalys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.SourceBillType;
import kd.tmc.fpm.business.domain.model.execbiasanalys.ExecBiasAnalys;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.IExecBiasAnalysBizService;
import kd.tmc.fpm.business.mvc.service.impl.ExecBiasAnalysBizServiceImpl;
import kd.tmc.fpm.business.opservice.execbiasanalys.ExecBiasAnalysSaveService;

public class ExecBiasAnalysDeleteService
extends AbstractTmcBizOppService {
    private IExecBiasAnalysBizService execBiasAnalysisBizService = new ExecBiasAnalysBizServiceImpl();
    private static Log logger = LogFactory.getLog(ExecBiasAnalysSaveService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebilltype");
        selector.add("sourcebill");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject dynamicObject : dynamicObjects) {
            FpmOperateResult<ExecBiasAnalys> execBiasAnalysOperateResult = this.execBiasAnalysisBizService.load((Long)dynamicObject.getPkValue());
            ExecBiasAnalys oldExecBiasAnalys = execBiasAnalysOperateResult.getData();
            Report report = EmptyUtil.isEmpty((Object)oldExecBiasAnalys.getReport()) ? (Report)oldExecBiasAnalys.getSumPlanReportList().get(0) : oldExecBiasAnalys.getReport();
            this.execBiasAnalysisBizService.delete(report);
        }
    }

    public void afterProcess(DynamicObject[] dynamicObjects) throws KDException {
        ArrayList<Long> reportIds = new ArrayList<Long>(2);
        ArrayList<Long> sumPlanIds = new ArrayList<Long>(2);
        for (DynamicObject bill : dynamicObjects) {
            if (SourceBillType.REPORT.getValue().equals(bill.getString("sourcebilltype"))) {
                reportIds.add(bill.getLong(String.join((CharSequence)".", "sourcebill", "id")));
            }
            if (!SourceBillType.SUMPLAN.getValue().equals(bill.getString("sourcebilltype"))) continue;
            sumPlanIds.add(bill.getLong(String.join((CharSequence)".", "sourcebill", "id")));
        }
        if (EmptyUtil.isNoEmpty(reportIds)) {
            DynamicObject[] reportBills = TmcDataServiceHelper.load((Object[])reportIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_report"));
            Arrays.stream(reportBills).forEach(c -> c.set("isexecbiasanalys", (Object)"0"));
            TmcDataServiceHelper.save((DynamicObject[])reportBills);
        }
        if (EmptyUtil.isNoEmpty(sumPlanIds)) {
            DynamicObject[] sumPlanBills = TmcDataServiceHelper.load((Object[])sumPlanIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_reportplansum"));
            Arrays.stream(sumPlanBills).forEach(c -> c.set("isexecbiasanalys", (Object)"0"));
            TmcDataServiceHelper.save((DynamicObject[])sumPlanBills);
        }
    }
}

