/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.inoutpool;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.common.enums.BillStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectApplyStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectApprovalStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectDataSourceEnum;
import kd.tmc.fpm.common.enums.InoutCycleEnum;
import kd.tmc.fpm.common.property.CronPlanTemplateProp;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CronPlanCollectGenerateBillService
extends AbstractTmcBizOppService {
    private static Log LOGGER = LogFactory.getLog(CronPlanCollectGenerateBillService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map operationVariable = this.getOperationVariable();
        int days = Integer.parseInt((String)operationVariable.get("GENERATE_OPERATOR_VARIABLE_DAYS"));
        String[] split = ((String)operationVariable.get("GENERATE_OPERATOR_VARIABLE_TEMPLATE_ID")).split(",");
        List<Long> templateIds = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
        this.generateCollectBill(days, templateIds);
    }

    private void generateCollectBill(int days, List<Long> templateIds) {
        block17: {
            OperationResult operationResult = this.getOperationResult();
            operationResult.setShowMessage(false);
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            try (TXHandle tx = TX.requiresNew();){
                try {
                    FpmOperateResult<Void> operateResult = this.doGenerateCollectBill(days, templateIds);
                    if (!operateResult.isSuccess()) {
                        if (operateResult.isWarning()) {
                            operateErrorInfo.setLevel(ErrorLevel.Warning);
                            operateErrorInfo.setMessage(operateResult.getWarnMessage());
                        } else {
                            operateErrorInfo.setLevel(ErrorLevel.Error);
                            operateErrorInfo.setMessage(operateResult.getMessageList().stream().collect(Collectors.joining(";")));
                        }
                        operationResult.setSuccess(false);
                        operationResult.addErrorInfo(operateErrorInfo);
                        tx.markRollback();
                        break block17;
                    }
                    operationResult.setSuccess(true);
                    operationResult.setMessage(ResManager.loadKDString((String)"\u6536\u652f\u8ba1\u5212\u5355\u751f\u6210\u6210\u529f\u3002", (String)"CronPlanCollectGenerateBillService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    tx.commit();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    operationResult.setSuccess(false);
                    tx.markRollback();
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setMessage(e.getMessage());
                    operationResult.addErrorInfo(operateErrorInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FpmOperateResult<Void> doGenerateCollectBill(int days, List<Long> templateIds) {
        block16: {
            Object[] objects = templateIds.toArray(new Object[0]);
            DynamicObject[] load = TmcDataServiceHelper.load((Object[])objects, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_cronplanmaintain"));
            Date currentDate = DateUtils.getCurrentDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currentDate);
            calendar.add(6, days);
            Date endTime = calendar.getTime();
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(128);
            ArrayList<String> successIds = new ArrayList<String>(load.length);
            HashSet<String> failedIds = new HashSet<String>(8);
            try {
                block15: {
                    this.batchLock(objects, successIds, failedIds);
                    if (CollectionUtils.isEmpty(successIds)) {
                        LOGGER.info("\u6240\u6709\u5355\u636eid:{}\u52a0\u9501\u5931\u8d25", failedIds);
                        FpmOperateResult<Void> fpmOperateResult = FpmOperateResult.error(ResManager.loadKDString((String)"\u6a21\u677f\u52a0\u9501\u5931\u8d25\u3002\u540c\u4e00\u65f6\u95f4\u53ea\u80fd\u6267\u884c\u4e00\u4e2a\u6a21\u677f\u7684\u751f\u6210\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CronPlanCollectGenerateBillService_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
                        return fpmOperateResult;
                    }
                    Map<String, String> existMap = this.getGeneratedInoutCollectBill(currentDate, endTime, successIds);
                    HashMap<Object, AtomicReference> endMap = new HashMap<Object, AtomicReference>(load.length);
                    HashMap<Object, AtomicReference> currentDateMap = new HashMap<Object, AtomicReference>(load.length);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    String endTimeStr = dateFormat.format(endTime);
                    do {
                        boolean end = true;
                        for (DynamicObject dy : load) {
                            String templateNumber = dy.getString("billno");
                            Object pkValue = dy.getPkValue();
                            AtomicReference endFlag = endMap.computeIfAbsent(pkValue, key -> new AtomicReference<Boolean>(Boolean.FALSE));
                            boolean bl = end = end && (Boolean)endFlag.get() != false;
                            if (end || ((Boolean)endFlag.get()).booleanValue()) continue;
                            if (!dy.getBoolean("enable")) {
                                endFlag.set(Boolean.TRUE);
                                LOGGER.info("\u6a21\u677f:{}\u4e0d\u53ef\u7528", (Object)templateNumber);
                                continue;
                            }
                            if (failedIds.contains(pkValue.toString())) {
                                LOGGER.info("\u6a21\u677f:{},\u5bf9\u5e94\u7684\u7533\u8bf7\u673a\u6784:{},\u6709\u522b\u7684\u7528\u6237\u6b63\u5728\u751f\u6210\u8bb0\u5f55\uff0c\u672c\u6b21\u4e0d\u751f\u6210", (Object)templateNumber, (Object)dy.getDynamicObject("applyorg").getString("number"));
                                endFlag.set(Boolean.TRUE);
                                continue;
                            }
                            AtomicReference currentDateRef = currentDateMap.computeIfAbsent(pkValue, key -> new AtomicReference<Date>(currentDate));
                            Date startDate = (Date)currentDateRef.get();
                            if (startDate.after(endTime)) {
                                endFlag.set(Boolean.TRUE);
                                LOGGER.info("\u6a21\u677f\uff1a{}\uff0c\u672c\u6b21\u5f00\u59cb\u65e5\u671f\uff1a{}\uff0c\u5927\u4e8e\u751f\u6210\u7ed3\u675f\u65e5\u671f\uff1a{}", new Object[]{templateNumber, dateFormat.format(startDate), endTimeStr});
                                continue;
                            }
                            Date expireDate = dy.getDate("expiredate");
                            if (expireDate != null && startDate.after(expireDate)) {
                                endFlag.set(Boolean.TRUE);
                                LOGGER.info("\u6a21\u677f\uff1a{}\uff0c\u672c\u6b21\u5f00\u59cb\u65e5\u671f\uff1a{}\uff0c\u5927\u4e8e\u6a21\u677f\u5931\u6548\u65e5\u671f", new Object[]{templateNumber, dateFormat.format(startDate), dateFormat.format(expireDate)});
                                continue;
                            }
                            String inoutCycle = dy.getString("inoutcycle");
                            InoutCycleEnum inoutCycleEnum = InoutCycleEnum.getByCode((String)inoutCycle);
                            Date firstDate = dy.getDate("firstexpectdate");
                            calendar.setTime(firstDate);
                            int day = calendar.get(5);
                            int repeatCycle = dy.getInt("repeatcycle");
                            firstDate = this.getGenerateStartExpectDate(dy, currentDateRef, currentDate, calendar);
                            InoutCycleEnum.InoutCycleDay inoutCycleDay = new InoutCycleEnum.InoutCycleDay(inoutCycleEnum, day, repeatCycle);
                            Date expectDate = inoutCycleDay.getExpectDate(firstDate, currentDateRef, calendar);
                            if (expectDate.after(endTime)) {
                                endFlag.set(Boolean.TRUE);
                                LOGGER.info("\u6a21\u677f\uff1a{}\uff0c\u672c\u6b21\u751f\u6210\u7684\u671f\u671b\u65e5\u671f\uff1a{}\uff0c\u5927\u4e8e\u751f\u6210\u7ed3\u675f\u65e5\u671f\uff1a{}", new Object[]{templateNumber, dateFormat.format(expectDate), endTimeStr});
                                continue;
                            }
                            if (expireDate != null && expectDate.after(expireDate)) {
                                endFlag.set(Boolean.TRUE);
                                LOGGER.info("\u6a21\u677f\uff1a{}\uff0c\u672c\u6b21\u751f\u6210\u7684\u671f\u671b\u65e5\u671f\uff1a{}\uff0c\u5927\u4e8e\u6a21\u677f\u5931\u6548\u65e5\u671f\uff1a{}", new Object[]{templateNumber, dateFormat.format(expectDate), dateFormat.format(expireDate)});
                                continue;
                            }
                            String expectDateStr = dateFormat.format(expectDate);
                            String key2 = String.join((CharSequence)"_", dy.getPkValue().toString(), expectDateStr);
                            if (existMap.containsKey(key2)) {
                                LOGGER.info("\u6a21\u677f:{},\u671f\u671b\u65e5\u671f:{},\u5df2\u7ecf\u751f\u6210\u4e86\u6536\u652f\u91c7\u96c6\u5355\uff1a{}", new Object[]{templateNumber, expectDateStr, existMap.get(key2)});
                                continue;
                            }
                            DynamicObject dynamicObject = TmcDataServiceHelper.newDynamicObject((String)"fpm_inoutcollect");
                            this.populateBaseProp(dynamicObject, dy);
                            dynamicObject.set("expectdate", (Object)expectDate);
                            dynamicObject.set("currentplandate", (Object)expectDate);
                            dynamicObjectList.add(dynamicObject);
                        }
                        if (!end) continue;
                        LOGGER.info("\u6240\u6709\u6a21\u677f\u90fd\u5df2\u5b8c\u6210\u5355\u636e\u751f\u6210");
                        break block15;
                    } while (!currentDate.after(endTime));
                    LOGGER.info("\u6700\u65b0\u5f53\u524d\u65e5\u671f\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u751f\u6210\u7ed3\u675f");
                }
                if (CollectionUtils.isNotEmpty(dynamicObjectList)) {
                    TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_inoutcollect", (DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create(), (boolean)false);
                    this.writeBackTemplate(load, dynamicObjectList);
                    break block16;
                }
                FpmOperateResult<Void> fpmOperateResult = FpmOperateResult.warn(ResManager.loadKDString((String)"\u6240\u6709\u5355\u636e\u5df2\u751f\u6210\uff0c\u65e0\u9700\u91cd\u590d\u751f\u6210\u3002", (String)"CronPlanCollectGenerateBillService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return fpmOperateResult;
            }
            finally {
                this.batchRelease(successIds);
            }
        }
        return FpmOperateResult.success();
    }

    private Date getGenerateStartExpectDate(DynamicObject dy, AtomicReference<Date> currentDateRef, Date currentDate, Calendar calendar) {
        Date firstDate = dy.getDate("firstexpectdate");
        if (currentDateRef.get() == currentDate) {
            return firstDate;
        }
        calendar.setTime(currentDateRef.get());
        calendar.add(5, -1);
        return calendar.getTime();
    }

    protected void writeBackTemplate(DynamicObject[] load, List<DynamicObject> dynamicObjectList) {
        Map<Long, List<DynamicObject>> listMap = dynamicObjectList.stream().filter(dynamicObject -> EmptyUtil.isNoEmpty((Long)dynamicObject.getLong("crontemplateid"))).collect(Collectors.groupingBy(dy -> dy.getLong("crontemplateid")));
        LOGGER.info("\u5f00\u59cb\u6a21\u677f\u56de\u5199");
        for (DynamicObject dynamicObject2 : load) {
            Long pkValue = (Long)dynamicObject2.getPkValue();
            List<DynamicObject> objectList = listMap.get(pkValue);
            String billNo = dynamicObject2.getString("billno");
            if (CollectionUtils.isEmpty(objectList)) {
                LOGGER.info("\u6a21\u677f\uff1a{}\uff0c\u672a\u751f\u6210\u91c7\u96c6\u5355", (Object)billNo);
                continue;
            }
            List sortedList = objectList.stream().sorted(Comparator.comparing(dy -> dy.getDate("expectdate"))).collect(Collectors.toList());
            DynamicObject recent = (DynamicObject)sortedList.get(sortedList.size() - 1);
            Date date = recent.getDate("expectdate");
            dynamicObject2.set("recentrecordexpectdate", (Object)date);
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_cronplanmaintain", (DynamicObject[])load, (OperateOption)OperateOption.create(), (boolean)false);
    }

    private void batchRelease(List<String> successIds) {
        try {
            if (CollectionUtils.isEmpty(successIds)) {
                return;
            }
            LOGGER.info("release cronLock\uff1a{}", successIds);
            Map releaseResultMap = MutexServiceHelper.batchRelease(successIds, (String)"tmc-fpm-business", (String)"fpm_cronplanmaintain");
            LOGGER.info("releaseResultMap is: {}", (Object)SerializationUtils.toJsonString((Object)releaseResultMap));
        }
        catch (Exception e1) {
            LOGGER.error((Throwable)e1);
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u652f\u91c7\u96c6\u5355\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5468\u671f\u6027\u8ba1\u5212\u3002", (String)"CronPlanCollectGenerateBillService_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }

    private void batchLock(Object[] objects, List<String> successIds, Set<String> failedIds) {
        List billIds = Arrays.stream(objects).filter(EmptyUtil::isNoEmpty).map(Object::toString).collect(Collectors.toList());
        LOGGER.info("\u52a0\u9501\u5355\u636eid\uff1a{}", billIds);
        try {
            Map lockResultMap = MutexServiceHelper.batchRequest(billIds, (String)"tmc-fpm-business", (String)"fpm_cronplanmaintain");
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (Boolean.TRUE.equals(next.getValue())) {
                    successIds.add(key);
                    continue;
                }
                failedIds.add(key);
            }
            if (CollectionUtils.isNotEmpty(failedIds)) {
                for (String requestFailId : failedIds) {
                    LOGGER.info(String.format("\u5355\u636eid: %s \u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", requestFailId));
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error("to get lock Exception is:", (Throwable)e1);
            LOGGER.info(ResManager.loadKDString((String)"\u5355\u636e\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"CronPlanCollectGenerateBillService_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
            throw e1;
        }
    }

    private Map<String, String> getGeneratedInoutCollectBill(Date currentDate, Date endTime, List<String> billIds) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List billIdList = billIds.stream().filter(EmptyUtil::isNoEmpty).map(Long::valueOf).collect(Collectors.toList());
        QFilter qFilter = new QFilter("expectdate", ">=", (Object)currentDate).and("expectdate", "<=", (Object)endTime).and("crontemplateid", "in", billIdList);
        String selectFields = String.join((CharSequence)",", "id", "billno", "name", "crontemplateid", "expectdate");
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_inoutcollect", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (load == null || load.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(load).collect(Collectors.toMap(inout -> String.join((CharSequence)"_", inout.getString("crontemplateid"), simpleDateFormat.format(inout.getDate("expectdate"))), inout -> inout.getString("billno")));
    }

    protected void populateBaseProp(DynamicObject dynamicObject, DynamicObject dy) {
        this.populateParentBaseInfoProp(dynamicObject, dy);
        for (Map.Entry entry : CronPlanTemplateProp.GENERATE_FILED_MAP.entrySet()) {
            Object sourceFieldVal;
            String sourceField = (String)entry.getKey();
            String targetField = (String)entry.getValue();
            if (StringUtils.isEmpty((CharSequence)targetField)) {
                targetField = sourceField;
            }
            if (EmptyUtil.isEmpty((Object)(sourceFieldVal = dy.get(sourceField))) && StringUtils.equals((CharSequence)sourceField, (CharSequence)"id")) {
                sourceFieldVal = dy.getPkValue();
            }
            dynamicObject.set(targetField, sourceFieldVal);
        }
        DynamicObject bosUser = TmcDataServiceHelper.newDynamicObject((String)"bos_user");
        bosUser.set("id", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("applyuser", (Object)bosUser);
        dynamicObject.set("creator", (Object)bosUser);
        dynamicObject.set("applystatus", (Object)InoutCollectApplyStatusEnum.NOT_APPLY.getCode());
        dynamicObject.set("approvalstatus", (Object)InoutCollectApprovalStatusEnum.NOT_APPROVAL.getCode());
        dynamicObject.set("billstatus", (Object)BillStatusEnum.STAGE.getCode());
        dynamicObject.set("datasource", (Object)InoutCollectDataSourceEnum.CRON_PLAN.getCode());
        dynamicObject.set("createdate", (Object)DateUtils.getCurrentDate());
    }

    private void populateParentBaseInfoProp(DynamicObject dynamicObject, DynamicObject dy) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fpm_inoutbaseinfo");
        Map allEntities = dataEntityType.getAllEntities();
        Optional<EntityType> any = allEntities.values().stream().filter(entityType -> entityType instanceof BillEntityType).findAny();
        if (!any.isPresent()) {
            return;
        }
        EntityType entityType2 = any.get();
        DataEntityPropertyCollection properties = entityType2.getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (CronPlanTemplateProp.IGNORE_PROP_NAME.contains(name)) continue;
            if (property instanceof LongProp && ((LongProp)property).isRefId()) {
                LOGGER.info("\u5c5e\u6027\uff1a{}\u4e3a\u57fa\u7840\u8d44\u6599\u7c7b\u578bid,\u8df3\u8fc7", (Object)name);
                continue;
            }
            if (property.isDbIgnore() && !(property instanceof BasedataProp)) {
                LOGGER.info("\u5c5e\u6027\uff1a{}\u4e3a\u6570\u636e\u5e93\u5ffd\u7565\u5c5e\u6027\uff0c\u5e76\u4e14\u4e0d\u662f\u57fa\u7840\u8d44\u6599\u7c7b\u578b\uff0c\u8df3\u8fc7", (Object)name);
                continue;
            }
            try {
                LOGGER.info("\u51c6\u5907\u8bbe\u7f6e\u5c5e\u6027\uff1a{}", (Object)name);
                dynamicObject.set(property, dy.get(property));
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

