/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.inspection;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectionExecType;
import kd.tmc.fpm.business.domain.enums.InspectionScope;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.inspection.DateRange;
import kd.tmc.fpm.business.domain.model.inspection.header.InspectHeader;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.service.inspection.IInspectionExecuteBizService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import org.apache.commons.collections.MapUtils;

public class ExecuteInspectionTaskService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ExecuteInspectionTaskService.class);
    private final IInspectionExecuteBizService inspectionExecuteBizService = FpmServiceFactory.getBizService(IInspectionExecuteBizService.class);
    private final IDimensionRepository dimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);

    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("enable");
        selectors.add("inspectionscope");
        selectors.add("bodysys.id");
        return selectors;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        Map<Long, List<DynamicObject>> inspectionConfigGroup = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("bodysys.id")));
        if (MapUtils.isEmpty(inspectionConfigGroup)) {
            return;
        }
        DateRange dateRange = this.getDateRange();
        logger.info("\u5f00\u59cb\u6267\u884c\u5de1\u68c0\u4efb\u52a1\uff0c\u65e5\u671f\u8303\u56f4\uff1a{}", (Object)dateRange);
        for (Map.Entry<Long, List<DynamicObject>> inspectionEntry : inspectionConfigGroup.entrySet()) {
            Long systemId = inspectionEntry.getKey();
            FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(systemId);
            List<DynamicObject> configList = inspectionEntry.getValue();
            for (DynamicObject inspectionConfig : configList) {
                try {
                    InspectHeader inspectHeader = this.wrapperHeader(dateRange, inspectionConfig, fundPlanSystem);
                    this.inspectionExecuteBizService.execute(inspectHeader);
                }
                catch (Exception e) {
                    logger.error("\u5de1\u68c0\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u5de1\u68c0\u914d\u7f6e\uff1a[{}]\uff0c\u5de1\u68c0\u914d\u7f6eid\uff1a[{}]", (Object)(inspectionConfig.getString("number") + " " + inspectionConfig.getString("name")), inspectionConfig.getPkValue());
                }
            }
        }
        logger.info("\u5de1\u68c0\u4efb\u52a1\u6267\u884c\u7ed3\u675f");
    }

    private InspectHeader wrapperHeader(DateRange dateRange, DynamicObject inspectionConfig, FundPlanSystem fundPlanSystem) {
        InspectHeader header = new InspectHeader();
        header.setInspectionConfigId((Long)inspectionConfig.getPkValue());
        InspectionScope inspectionScope = ITypeEnum.getByNumber(inspectionConfig.getString("inspectionscope"), InspectionScope.class);
        if (inspectionScope == InspectionScope.BILL_INSPECTION) {
            header.setExecType(InspectionExecType.BY_DATE);
            header.setStartDate(dateRange.getStartDate());
            header.setEndDate(dateRange.getEndDate());
        } else {
            header.setExecType(InspectionExecType.BY_PERIOD);
            List<Long> periodScope = this.getPeriodScope(dateRange, fundPlanSystem);
            header.setPeriodScope(periodScope);
        }
        return header;
    }

    private DateRange getDateRange() {
        String dayScope = (String)this.getOperationVariable().get("day_scope");
        Date now = new Date();
        switch (dayScope) {
            case "CURR_WEEK": {
                return new DateRange(DateUtils.getFirstDayOfWeek((Date)now), DateUtils.getLastDay((Date)DateUtils.getNextWeekMonday((Date)now), (int)1));
            }
            case "CURR_MONTH": {
                return new DateRange(DateUtils.getFirstDayOfCurMonth(), DateUtils.getLastDayOfCurMonth());
            }
            case "LAST_MONTH": {
                return new DateRange(DateUtils.getLastMonth((Date)now, (int)1), now);
            }
            case "LAST_THREE_MONTH": {
                return new DateRange(DateUtils.getLastMonth((Date)now, (int)3), now);
            }
        }
        return new DateRange(now, now);
    }

    private List<Long> getPeriodScope(DateRange dateRange, FundPlanSystem system) {
        Set periodTypeSet = system.getReportTypeList().stream().filter(ReportPeriodType::isEnable).map(ReportPeriodType::getPeriodType).collect(Collectors.toSet());
        List periodMemberList = system.getDimList().stream().filter(dimension -> dimension.getDimType() == DimensionType.PERIOD).flatMap(dimension -> dimension.getAllDimMemberList().stream()).map(PeriodMember.class::cast).filter(periodMember -> periodTypeSet.contains((Object)periodMember.getPeriodType())).filter(periodMember -> dateRange.isInRange(periodMember.getStartDate())).collect(Collectors.toList());
        String periodName = periodMemberList.stream().map(DimMember::getName).collect(Collectors.joining(","));
        logger.info("\u6267\u884c\u5de1\u68c0\u4efb\u52a1\uff0c\u671f\u95f4\u8303\u56f4\uff1a{}", (Object)periodName);
        return periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList());
    }
}

