/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.common.enums.ReportPlanChangeStatusEnum;

public class ReportChangeDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("billstatus");
        selector.add("originalreportids");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        DynamicObject[] reportDBDataArr;
        Set reportIdS = Arrays.stream(dynamicObjects).map(item -> Arrays.asList(item.getString("originalreportids").split(","))).flatMap(Collection::stream).map(item -> Long.valueOf(item)).collect(Collectors.toSet());
        for (DynamicObject reportDBData : reportDBDataArr = TmcDataServiceHelper.load((String)"fpm_report", (String)"changestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", reportIdS)})) {
            boolean changed = QueryServiceHelper.exists((String)"fpm_reportplan_adjust", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("originalreportids", "like", (Object)("%" + reportDBData.getLong("id") + "%"))});
            reportDBData.set("changestatus", (Object)(changed ? ReportPlanChangeStatusEnum.CHANGED.getValue() : ReportPlanChangeStatusEnum.UNCHANGE.getValue()));
        }
        SaveServiceHelper.save((DynamicObject[])reportDBDataArr);
    }
}

