/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fpm.business.domain.enums.ReportPlanChangeStatus;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IPlanChangeRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.PlanChangeRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.IPlanChangeBizService;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateAsyncService;
import kd.tmc.fpm.business.mvc.service.calculate.impl.ReportCalculateAsyncServiceImpl;
import kd.tmc.fpm.business.mvc.service.impl.PlanChangeBizServiceImpl;

public class ReportChangeSyncAuditService
extends AbstractTmcBizOppService {
    private IPlanChangeBizService changeBizService = new PlanChangeBizServiceImpl();
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private ReportCalculateAsyncService calculateAsyncService = new ReportCalculateAsyncServiceImpl();
    private IPlanChangeRepository repository = new PlanChangeRepository();
    private IReportRepository reportRepository = new ReportRepository();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("billstatus");
        selector.add("bodysys.id");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject dynamicObject : dynamicObjects) {
            long id = dynamicObject.getLong("id");
            long sysId = dynamicObject.getLong("bodysys.id");
            PlanChangeRecord changeData = this.repository.load(id);
            List<PlanChangeReport> changeReportList = changeData.getChangeReportList();
            Set<Long> reportIdS = changeReportList.stream().map(PlanChangeReport::getReportId).collect(Collectors.toSet());
            List<Report> reportList = this.reportRepository.loadReport(reportIdS);
            boolean changed = reportList.stream().anyMatch(i -> i.getChangeStatus() == ReportPlanChangeStatus.CHANGED);
            if (changed) {
                return;
            }
            FpmOperateResult<Set<Long>> audit = this.changeBizService.audit(id);
            if (!audit.isSuccess()) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(dynamicObject.get("billno") + ":" + String.join((CharSequence)";", audit.getMessageList()));
                operateErrorInfo.setPkValue(dynamicObject.getPkValue());
                this.operationResult.addErrorInfo(operateErrorInfo);
                this.operationResult.setSuccess(false);
                dynamicObject.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
                continue;
            }
            Set<Long> reportIds = audit.getData();
            FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(sysId);
            if (CollectionUtils.isEmpty(reportIds)) {
                return;
            }
            this.calculateAsyncService.updateBeginEndSubjectRealAmount(String.valueOf(id), reportIds, null, fundPlanSystem);
        }
    }
}

