/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.IPlanChangeBizService;
import kd.tmc.fpm.business.mvc.service.impl.PlanChangeBizServiceImpl;

public class ReportPlanChangeService
extends AbstractTmcBizOppService {
    private IPlanChangeBizService changeBizService = new PlanChangeBizServiceImpl();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("planstatus");
        selector.add("billno");
        selector.add("reportorg");
        selector.add("reportperiod");
        selector.add("changestatus");
        selector.add("name");
        selector.add("template.ismaintable");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        FpmOperateResult<Long> result;
        Set<Long> reportIdS = Arrays.stream(dynamicObjects).map(item -> item.getLong("id")).collect(Collectors.toSet());
        Optional<DynamicObject> first = Arrays.stream(dynamicObjects).filter(item -> item.getBoolean("template.ismaintable")).findFirst();
        if (!first.isPresent()) {
            DynamicObject firstSubData = dynamicObjects[0];
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
            qFilterList.add(new QFilter("reportorg.id", "=", (Object)firstSubData.getLong("reportorg.id")));
            qFilterList.add(new QFilter("reportperiod.id", "=", (Object)firstSubData.getLong("reportperiod.id")));
            qFilterList.add(new QFilter("template.id", "=", (Object)firstSubData.getLong("parenttemplate.id")));
            DynamicObject[] mainTableArr = TmcDataServiceHelper.load((String)"fpm_report", (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
            reportIdS.add(mainTableArr[0].getLong("id"));
        }
        if (!(result = this.changeBizService.create(reportIdS)).isSuccess()) {
            throw new KDBizException(JSON.toJSONString(result.getMessageList()));
        }
        Long changRecordId = result.getData();
        OperationResult operationResult = this.getOperationResult();
        InteractionContext interactionContext = new InteractionContext();
        interactionContext.getCustShowParameter().put("planchangeid", String.valueOf(changRecordId));
        operationResult.setInteractionContext(interactionContext);
    }
}

