/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.dto.RecalculateReportPlanAmtParamDTO;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ReportPlanRecalculateAmtService
extends AbstractTmcBizOppService {
    private IReportBizService iReportBizService = FpmServiceFactory.getBizService(IReportBizService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("bodysys.id");
        selector.add("reportorg.id");
        selector.add("reportperiod.id");
        selector.add("planstatus");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        Long systemId = dynamicObjects[0].getLong("bodysys.id");
        Long reportPeriodId = dynamicObjects[0].getLong("reportperiod.id");
        List<Long> reportIds = Arrays.stream(dynamicObjects).filter(dy -> ReportStatus.ENABLE == ReportStatus.getByVal(dy.getString("planstatus"))).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        RecalculateReportPlanAmtParamDTO qParam = new RecalculateReportPlanAmtParamDTO();
        qParam.setSystemId(systemId);
        qParam.setReportPeriodId(reportPeriodId);
        qParam.setReportIds(reportIds);
        this.iReportBizService.recalculateReportPlanAmt(qParam);
    }
}

