/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ReportPlanSmartGelValService
extends AbstractTmcBizOppService {
    private IDimensionRepository iDimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);
    private IControlRepository iControlRepository = FpmServiceFactory.getBizService(IControlRepository.class);
    private IReportRepository iReportRepository = FpmServiceFactory.getBizService(IReportRepository.class);
    private IReportBizService iReportBizService = new ReportBizService();
    private static final int SYSTEM_BATCH_SIZE = 2;
    private static final int REPORT_BATCH_SIZE = 5;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bodysys.id");
        selector.add("billno");
        selector.add("id");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        Map systemReportGroupMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("bodysys.id"), HashMap::new, Collectors.toList()));
        ArrayList systemIds = new ArrayList(systemReportGroupMap.keySet());
        List systemIdGroup = Lists.partition(systemIds, (int)2);
        for (List currDealSystemIds : systemIdGroup) {
            HashSet<Long> currDealSystemIdSet = new HashSet<Long>(currDealSystemIds);
            List<BillMatchRule> billMatchRules = this.iControlRepository.loadPlanMatchRules("fpm_inoutcollect", currDealSystemIds);
            Map systemRuleMap = billMatchRules.stream().collect(Collectors.toMap(BillMatchRule::getSystemId, Function.identity(), (a, b) -> b));
            List<FundPlanSystem> fundPlanSystems = this.iDimensionRepository.loadSystems(currDealSystemIdSet);
            for (FundPlanSystem fundPlanSystem : fundPlanSystems) {
                this.systemSmartGetVal(fundPlanSystem, (BillMatchRule)systemRuleMap.get(fundPlanSystem.getId()), (List)systemReportGroupMap.get(fundPlanSystem.getId()));
            }
        }
    }

    private void systemSmartGetVal(FundPlanSystem fundPlanSystem, BillMatchRule billMatchRule, List<DynamicObject> reportDyList) {
        if (Objects.isNull(fundPlanSystem) || Objects.isNull(billMatchRule) || EmptyUtil.isEmpty(reportDyList)) {
            return;
        }
        List reportIds = reportDyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List reportIdGroup = Lists.partition(reportIds, (int)5);
        for (List currDealReportIds : reportIdGroup) {
            HashSet<Long> currDealReportIdSet = new HashSet<Long>(currDealReportIds);
            List<Report> currDealReports = this.iReportRepository.loadReport(currDealReportIdSet);
            currDealReports.forEach(report -> {
                ReportTemplate reportTemplate = report.getTemplate();
                List<TemplateDim> templateDimList = reportTemplate.getAllTemplateDim();
                this.iReportBizService.smartGetVal(billMatchRule, (Report)report, fundPlanSystem, templateDimList, true);
            });
        }
    }
}

