/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportOpType;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;

public class ReportPlanSubmitService
extends AbstractTmcBizOppService {
    private ReportBizService reportBizService = new ReportBizService();
    private final IDataSaveService dataSaveService = new DataSaveServiceImpl();
    private ITemplateRepository iTemplateRepository = new TemplateRepository();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("billno");
        selector.add("informant");
        selector.add("reportperiod.id");
        selector.add("zeroreport");
        selector.add("templatebak.id");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        String reportOpType = (String)this.getOperationVariable().get("ReportOpType");
        if (ReportOpType.OP.getNumber().equals(reportOpType)) {
            if (!this.genEmptyReportDataIfMainTable(dynamicObjects[0].getLong("id"), dynamicObjects[0].getLong("templatebak.id"))) {
                this.setZeroReport(dynamicObjects[0]);
            }
            return;
        }
        List reportIds = Arrays.stream(dynamicObjects).map(item -> item.getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(reportIds)) {
            return;
        }
        int batchSize = 5;
        List partitionIds = Lists.partition(reportIds, (int)batchSize);
        partitionIds.forEach(ids -> {
            HashSet<Long> reportIdSet = new HashSet<Long>((Collection<Long>)ids);
            this.reportBizService.batchSubmitReport(reportIdSet);
        });
    }

    private void setZeroReport(DynamicObject dynamicObject) {
        long reportId = dynamicObject.getLong("id");
        long reportPeriodId = dynamicObject.getLong("reportperiod.id");
        QFilter qFilter = new QFilter("id", "=", (Object)reportId).and("maindimentry.entryreportperiod", "=", (Object)reportPeriodId).and("maindimentry.planamt", "!=", (Object)BigDecimal.ZERO);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"fpm_report", (String)"maindimentry.id", (QFilter[])new QFilter[]{qFilter});
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_report set fzeroreport = ? where fid =?", Collections.singletonList(reportId), (t, d) -> {
            d.add(Objects.isNull(queryOne) ? "1" : "0");
            d.add(t);
        });
    }

    private boolean genEmptyReportDataIfMainTable(Long reportId, Long templateBakId) {
        ReportTemplate template = this.iTemplateRepository.loadTemplateBak(templateBakId);
        boolean noNeedGen = !template.isMainTable();
        boolean bl = noNeedGen = noNeedGen || template.getAccountSettings().stream().noneMatch(item -> ReportInputType.DETAIL_INPUT == item.getInputType());
        if (noNeedGen) {
            return false;
        }
        this.reportBizService.batchSubmitReport(Sets.newHashSet((Object[])new Long[]{reportId}));
        return true;
    }
}

