/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;

public class ReportSumPlanUnAuditService
extends AbstractTmcBizOppService {
    private ISumPlanBizService service = new SumPlanBizServiceImpl();
    private IDimensionRepository dimensionRepository = new DimensionRepository();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("billstatus");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        HashMap<Long, FundPlanSystem> systemMap = new HashMap<Long, FundPlanSystem>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long id = dynamicObject.getLong("id");
            long systemId = dynamicObject.getLong(String.join((CharSequence)".", "bodysys", "id"));
            FundPlanSystem fundPlanSystem = systemMap.computeIfAbsent(systemId, key -> this.dimensionRepository.loadSystem(systemId));
            FpmOperateResult<Void> unAudit = this.service.unAudit(id, fundPlanSystem);
            if (unAudit.isSuccess()) continue;
            String errMsg = dynamicObject.get("billno") + ":" + String.join((CharSequence)";", unAudit.getMessageList());
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(errMsg);
            operateErrorInfo.setPkValue(dynamicObject.getPkValue());
            this.operationResult.addErrorInfo(operateErrorInfo);
            this.operationResult.setSuccess(false);
            dynamicObject.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        }
    }
}

