/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report.mutex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategy;
import kd.tmc.fpm.business.opservice.report.mutex.MutexRequestInfo;

public class ReportMutexLockService
implements ILockStrategy {
    private final List<MutexRequestInfo> mutexRequestInfoList;
    private final List<String> successIds;
    private static final String OP = "reportPlanLockSumPlan";
    private boolean locked;
    private static final Log logger = LogFactory.getLog(ReportMutexLockService.class);

    private ReportMutexLockService() {
        this(new ArrayList<MutexRequestInfo>(16));
    }

    public ReportMutexLockService(List<MutexRequestInfo> mutexRequestInfoList) {
        this.mutexRequestInfoList = mutexRequestInfoList;
        this.successIds = new ArrayList<String>(16);
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean tryLock() {
        this.doTryLock();
        return this.locked;
    }

    private void doTryLock() {
        logger.info("batchLock:{}", this.mutexRequestInfoList);
        if (EmptyUtil.isEmpty(this.mutexRequestInfoList)) {
            this.locked = true;
            return;
        }
        Map<Long, List<MutexRequestInfo>> mutexRequestInfoMap = this.mutexRequestInfoList.stream().collect(Collectors.groupingBy(mutexRequestInfo -> mutexRequestInfo.getSumPlanRecord().getId()));
        List stringList = mutexRequestInfoMap.keySet().stream().map(String::valueOf).distinct().collect(Collectors.toList());
        Map stringBooleanMap = MutexServiceHelper.batchRequest(stringList, (String)"fpm_reportplansum", (String)OP);
        Optional<Map.Entry> first = stringBooleanMap.entrySet().stream().filter(entry -> {
            Boolean entryValue = (Boolean)entry.getValue();
            if (entryValue == null) {
                return true;
            }
            if (entryValue.booleanValue()) {
                this.successIds.add((String)entry.getKey());
            }
            return entryValue == false;
        }).findFirst();
        logger.info("successIds:{}", this.successIds);
        if (first.isPresent()) {
            Map.Entry entry2 = first.get();
            String key = (String)entry2.getKey();
            List mutexRequestInfoList = mutexRequestInfoMap.getOrDefault(Long.parseLong(key), Collections.emptyList());
            String sumPlanRecord = "";
            StringBuilder reportPlan = new StringBuilder();
            for (MutexRequestInfo mutexRequestInfo2 : mutexRequestInfoList) {
                if (EmptyUtil.isEmpty((String)sumPlanRecord)) {
                    sumPlanRecord = mutexRequestInfo2.getSumPlanRecord().getNumber();
                }
                reportPlan.append(mutexRequestInfo2.getReportPlanNo()).append(",");
            }
            if (reportPlan.length() > 0) {
                reportPlan.deleteCharAt(reportPlan.length() - 1);
            }
            String message = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u7f16\u5236\u5355\u636e\u3010%1$s\u3011\u4e0a\u6e38\u6c47\u603b\u7f16\u5236\u5355\u636e\u3010%2$s\u3011\u6709\u5176\u4ed6\u4e0b\u6e38\u8ba1\u5212\u7f16\u5236\u5355\u636e\u6b63\u5728\u5ba1\u6838\u6216\u8005\u53cd\u5ba1\u6838\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReportMutexLockService_1", (String)"tmc-fpm-business", (Object[])new Object[0]), reportPlan, sumPlanRecord);
            logger.error(message);
            return;
        }
        this.locked = true;
    }

    @Override
    public void lock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unLock() {
        logger.info("batchRelease:{}", this.successIds);
        if (EmptyUtil.isEmpty(this.successIds)) {
            return;
        }
        MutexServiceHelper.batchRelease(this.successIds, (String)"fpm_reportplansum", (String)OP);
        this.locked = false;
        this.successIds.clear();
    }

    public Map<Long, SumPlanRecord> getLockedSumPlanRecordMap() {
        if (EmptyUtil.isEmpty(this.successIds)) {
            return Collections.emptyMap();
        }
        HashSet<String> lockedSumRecordIds = new HashSet<String>(this.successIds);
        return this.mutexRequestInfoList.stream().filter(mutexRequestInfo -> lockedSumRecordIds.contains(mutexRequestInfo.getWaitLockReportId())).collect(Collectors.toMap(MutexRequestInfo::getReportPlanId, MutexRequestInfo::getSumPlanRecord));
    }

    public List<MutexRequestInfo> getMutexRequestInfoList() {
        return this.mutexRequestInfoList;
    }
}

