/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.report.mutex;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategy;
import kd.tmc.fpm.business.opservice.report.mutex.ILockStrategyFactory;
import kd.tmc.fpm.business.opservice.report.mutex.MutexRequestInfo;
import kd.tmc.fpm.business.opservice.report.mutex.ReportMutexLockService;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.helper.StringHelper;

public class ReportPlanLockStrategyFactory
implements ILockStrategyFactory {
    @Override
    public ILockStrategy getLockStrategy(List<TaskRecord> taskRecordList) {
        if (EmptyUtil.isEmpty(taskRecordList)) {
            throw new KDBizException("taskRecordList is empty.");
        }
        TaskRecord taskRecord = taskRecordList.get(0);
        String taskInfo = taskRecord.getTaskInfo();
        Map jsonMap = (Map)SerializationUtils.fromJsonString((String)taskInfo, Map.class);
        MutexRequestInfo mutexRequestInfo = new MutexRequestInfo();
        mutexRequestInfo.setReportPlanNo(StringHelper.getStringValue(jsonMap.get("reportPlanNo")));
        String reportPlanIdStr = StringHelper.getStringValue(jsonMap.get("reportPlanId"));
        Long reportPlanId = EmptyUtil.isEmpty((String)reportPlanIdStr) ? 0L : Long.parseLong(reportPlanIdStr);
        mutexRequestInfo.setReportPlanId(reportPlanId);
        mutexRequestInfo.setWaitLockReportId(taskRecord.getGroupId());
        String selectFields = String.join((CharSequence)",", "bodysys", "billno", "id", "reporttype", "reportperiod", "reportorg");
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(mutexRequestInfo.getWaitLockReportId()));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_reportplansum", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            throw new KDBizException("");
        }
        DynamicObject sumRecordDy = (DynamicObject)dynamicObjectCollection.get(0);
        SumPlanRecord sumPlanRecord = new SumPlanRecord();
        sumPlanRecord.setReportPeriod(sumRecordDy.getLong("reportperiod"));
        sumPlanRecord.setReportOrg(sumRecordDy.getLong("reportorg"));
        sumPlanRecord.setId(sumRecordDy.getLong("id"));
        sumPlanRecord.setNumber(sumRecordDy.getString("billno"));
        sumPlanRecord.setSystemId(sumRecordDy.getLong("bodysys"));
        mutexRequestInfo.setSumPlanRecord(sumPlanRecord);
        return new ReportMutexLockService(ListHelper.asList(mutexRequestInfo));
    }
}

