/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.opservice.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.common.enums.WaysEnum;

public class TemplateInfoDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("ismaintable");
        selector.add("templateuses");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        List subTableList = Arrays.stream(dynamicObjects).filter(item -> !item.getBoolean("ismaintable")).collect(Collectors.toList());
        List subTableIdList = subTableList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter[] qFilters = new QFilter[]{new QFilter("subjecttentry.subtemplate", "in", subTableIdList)};
        DynamicObject[] mainTableArr = TmcDataServiceHelper.load((String)"fpm_template", (String)"id", (QFilter[])qFilters);
        Object[] templateIds = Arrays.stream(mainTableArr).map(DataEntityBase::getPkValue).toArray();
        mainTableArr = TmcDataServiceHelper.load((Object[])templateIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template"));
        for (DynamicObject dy : dynamicObjects) {
            List<DynamicObject> mainTableList;
            Object pkValue = dy.getPkValue();
            if (dy.getBoolean("ismaintable") || CollectionUtils.isEmpty(mainTableList = Arrays.stream(mainTableArr).filter(item -> item.getDynamicObjectCollection("subjecttentry").stream().filter(subjectItem -> subjectItem.get("subtemplate") != null).map(subjectItem -> subjectItem.getLong("subtemplate.id")).collect(Collectors.toList()).contains(pkValue)).collect(Collectors.toList()))) continue;
            for (DynamicObject mainTable : mainTableList) {
                DynamicObjectCollection subjectColl = mainTable.getDynamicObjectCollection("subjecttentry");
                List currSubSubjectList = subjectColl.stream().filter(item -> item.get("subtemplate") != null).filter(item -> pkValue.equals(item.getLong("subtemplate.id"))).collect(Collectors.toList());
                for (DynamicObject currSubSubject : currSubSubjectList) {
                    currSubSubject.set("subtemplate", null);
                    currSubSubject.set("reportways", (Object)WaysEnum.MANUAL_INPUT.getValue());
                }
                Set templateIdList = subjectColl.stream().filter(item -> item.get("subtemplate") != null).map(item -> item.getLong("subtemplate.id")).collect(Collectors.toSet());
                mainTable.set("subtemplatecount", (Object)templateIdList.size());
            }
            SaveServiceHelper.save((DynamicObject[])mainTableList.toArray(new DynamicObject[0]));
        }
        this.deleteBakTemplate(dynamicObjects);
    }

    private void deleteBakTemplate(DynamicObject[] dynamicObjects) {
        List sumPlanTemplate = Arrays.stream(dynamicObjects).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sumPlanTemplate)) {
            return;
        }
        DynamicObjectCollection templateBakCollection = QueryServiceHelper.query((String)"fpm_template_bak", (String)"id,templateid", (QFilter[])new QFilter[]{new QFilter("templateid", "in", (Object)sumPlanTemplate.stream().map(DataEntityBase::getPkValue).toArray())});
        if (CollectionUtils.isEmpty((Collection)templateBakCollection)) {
            return;
        }
        Map<Long, List<DynamicObject>> templateMap = templateBakCollection.stream().collect(Collectors.groupingBy(i -> i.getLong("templateid")));
        List templateBakIds = templateBakCollection.stream().filter(Objects::nonNull).map(item -> item.getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(templateBakIds)) {
            return;
        }
        DynamicObjectCollection effectReport = QueryServiceHelper.query((String)"fpm_report", (String)"id,templatebak", (QFilter[])new QFilter[]{new QFilter("templatebak", "in", templateBakIds), new QFilter("planstatus", "=", (Object)ReportStatus.ENABLE.getVal())});
        if (CollectionUtils.isEmpty((Collection)effectReport)) {
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"fpm_template_bak"), (Object[])templateBakIds.toArray());
            return;
        }
        ArrayList deleteIds = new ArrayList(templateBakIds.size());
        Set effectTemplateIdSet = effectReport.stream().map(i -> i.getLong("templatebak")).collect(Collectors.toSet());
        for (DynamicObject sumTemplate : sumPlanTemplate) {
            Long pkValue = (Long)sumTemplate.getPkValue();
            List<DynamicObject> templateBakList = templateMap.get(pkValue);
            if (CollectionUtils.isEmpty(templateBakList)) continue;
            List idList = templateBakList.stream().filter(Objects::nonNull).map(i -> (Long)i.getPkValue()).filter(Objects::nonNull).collect(Collectors.toList());
            boolean hasAnyEffectReportRel = idList.stream().anyMatch(effectTemplateIdSet::contains);
            if (hasAnyEffectReportRel) continue;
            deleteIds.addAll(idList);
        }
        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"fpm_template_bak"), (Object[])deleteIds.toArray());
    }
}

