/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.provider;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.model.dimension.DimMemberMapping;
import kd.tmc.fpm.business.domain.model.dimension.MappingInfo;
import kd.tmc.fpm.business.provider.FpmBaseDataProvider;

public class DimMappingBaseDataProvider
extends FpmBaseDataProvider {
    public DimMappingBaseDataProvider(List<DimMemberMapping> memberMappingList) {
        this.initDataMap(memberMappingList);
    }

    private void initDataMap(List<DimMemberMapping> memberMappingList) {
        HashMap baseDataIdMap = new HashMap(16);
        for (DimMemberMapping dimMemberMapping : memberMappingList) {
            Set currAssistIdList;
            String mainEntityType = dimMemberMapping.getMainEntityType();
            String assistEntityType = dimMemberMapping.getAssistEntityType();
            boolean assistEntity = dimMemberMapping.isAssistEntity();
            List<MappingInfo> mappings = dimMemberMapping.getMappings();
            Set currMainIdList = mappings.stream().map(item -> item.getMainId()).collect(Collectors.toSet());
            if (currMainIdList != null) {
                Set mainIdSet = (Set)baseDataIdMap.get(mainEntityType);
                if (mainIdSet != null) {
                    currMainIdList.addAll(mainIdSet);
                }
                baseDataIdMap.put(mainEntityType, currMainIdList);
            }
            if (!assistEntity || (currAssistIdList = mappings.stream().map(item -> item.getAssistId()).collect(Collectors.toSet())) == null) continue;
            Set assistIdList = (Set)baseDataIdMap.get(assistEntityType);
            if (assistIdList != null) {
                currAssistIdList.addAll(assistIdList);
            }
            baseDataIdMap.put(assistEntityType, currAssistIdList);
        }
        for (Map.Entry entry : baseDataIdMap.entrySet()) {
            String entityType = (String)entry.getKey();
            Set idSet = (Set)entry.getValue();
            if (idSet.size() <= 0) continue;
            List collect = idSet.stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
            Map<Object, DynamicObject> dataMap = Arrays.stream(TmcDataServiceHelper.load((Object[])collect.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityType))).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
            this.baseDataMap.put(entityType, dataMap);
        }
    }
}

