/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.provider;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.provider.FpmBaseDataProvider;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import org.apache.commons.lang3.StringUtils;

public class ReportBaseDataByCacheCellProvider
extends FpmBaseDataProvider {
    public ReportBaseDataByCacheCellProvider(List<Cell> cacheCellList) {
        this.initDataMap(cacheCellList);
    }

    private void initDataMap(List<Cell> cacheCellList) {
        HashMap<String, Set> baseDataIdMap = new HashMap<String, Set>();
        for (Cell cell : cacheCellList) {
            Object value;
            CellTypeEnum cellType = cell.getCellType();
            if (CellTypeEnum.F7WIDGET != cellType || (value = cell.getWidgetValue()) == null || cell.getValue() == null || !StringUtils.isNotEmpty((CharSequence)value.toString())) continue;
            Set idSet = (Set)baseDataIdMap.get(value.toString());
            idSet = idSet == null ? new HashSet(10) : idSet;
            idSet.add(cell.getValue());
            baseDataIdMap.put(value.toString(), idSet);
        }
        for (Map.Entry entry : baseDataIdMap.entrySet()) {
            String entityType = (String)entry.getKey();
            Set idSet = (Set)entry.getValue();
            if (idSet.size() <= 0) continue;
            List collect = idSet.stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
            Map<Object, DynamicObject> dataMap = Arrays.stream(TmcDataServiceHelper.load((Object[])collect.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityType))).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
            this.baseDataMap.put(entityType, dataMap);
        }
    }
}

