/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.provider;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.provider.FpmBaseDataProvider;
import org.apache.commons.lang3.StringUtils;

public class ReportBaseDataByCalcValProvider
extends FpmBaseDataProvider {
    public ReportBaseDataByCalcValProvider(List<ReportCalcVal> calcValList) {
        this.initDataMap(calcValList);
    }

    private void initDataMap(List<ReportCalcVal> calcValList) {
        HashMap<String, Set> baseDataIdMap = new HashMap<String, Set>();
        for (ReportCalcVal reportCalcVal : calcValList) {
            Object value;
            ReportValueType valueType = reportCalcVal.getValueType();
            ReportCellType reportCellType = valueType.getReportCellType();
            if (ReportCellType.BASE_DATA != reportCellType || (value = valueType.getValue()) == null || reportCalcVal.getValue() == null || !StringUtils.isNotEmpty((CharSequence)value.toString())) continue;
            Set idSet = (Set)baseDataIdMap.get(value.toString());
            idSet = idSet == null ? new HashSet(10) : idSet;
            idSet.add(reportCalcVal.getValue());
            baseDataIdMap.put(value.toString(), idSet);
        }
        for (Map.Entry entry : baseDataIdMap.entrySet()) {
            String entityType = (String)entry.getKey();
            Set idSet = (Set)entry.getValue();
            if (idSet.size() <= 0) continue;
            List collect = idSet.stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
            Map<Object, DynamicObject> dataMap = Arrays.stream(TmcDataServiceHelper.load((Object[])collect.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityType))).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
            this.baseDataMap.put(entityType, dataMap);
        }
    }
}

