/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.provider;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.provider.FpmBaseDataProvider;
import org.apache.commons.collections.CollectionUtils;

public class ReportDataBaseDataByNameProvider
extends FpmBaseDataProvider {
    public ReportDataBaseDataByNameProvider(List<ReportData> reportDataList) {
        this.initDataMap(reportDataList);
    }

    private void initDataMap(List<ReportData> reportDataList) {
        HashMap<String, Set> baseDataIdMap = new HashMap<String, Set>();
        for (ReportData reportData : reportDataList) {
            List<TemplateDim> dimList = reportData.getDimList();
            List<Object> dimValList = reportData.getDimValList();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                Object dimVal = dimValList.get(i);
                DetailDimType detailDimType = templateDim.getDetailDimType();
                if (detailDimType == DetailDimType.COUNTERPARTY_NAME) {
                    int index;
                    String bdEntity;
                    Optional<TemplateDim> first = dimList.stream().filter(item -> item.getDetailDimType() == DetailDimType.CONNTERPARTY_TYPE).findFirst();
                    if (!first.isPresent() || !StringUtils.isNotEmpty((CharSequence)(bdEntity = (String)dimValList.get(index = dimList.indexOf(first.get()))))) continue;
                    Set idSet = (Set)baseDataIdMap.get(bdEntity);
                    idSet = idSet == null ? new HashSet(16) : idSet;
                    idSet.add(dimVal);
                    baseDataIdMap.put(bdEntity, idSet);
                    continue;
                }
                if (detailDimType != DetailDimType.BANK_CATE && detailDimType != DetailDimType.BANK_ACCOUNT && detailDimType != DetailDimType.BUSINESS_PARTNER) continue;
                String bdEntity = (String)detailDimType.getExtVal();
                Set idSet = (Set)baseDataIdMap.get(bdEntity);
                idSet = idSet == null ? new HashSet(16) : idSet;
                idSet.add(dimVal);
                baseDataIdMap.put(bdEntity, idSet);
            }
        }
        for (Map.Entry entry : baseDataIdMap.entrySet()) {
            DynamicObjectCollection queryColl;
            String entityType = (String)entry.getKey();
            Set idSet = (Set)entry.getValue();
            if (idSet.size() <= 0) continue;
            List collect = idSet.stream().filter(item -> item != null).map(item -> item.toString()).collect(Collectors.toList());
            DynamicObject[] load = new DynamicObject[]{};
            if (CollectionUtils.isNotEmpty(collect) && CollectionUtils.isNotEmpty((Collection)(queryColl = QueryServiceHelper.query((String)entityType, (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "in", collect)})))) {
                collect = queryColl.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
                load = TmcDataServiceHelper.load((Object[])collect.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityType));
            }
            Map<Object, DynamicObject> dataMap = Arrays.stream(load).collect(Collectors.toMap(item -> item.getString("name"), o -> o, (k1, k2) -> k1));
            this.baseDataMap.put(entityType, dataMap);
        }
    }
}

