/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.copy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DynamicObjectUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.copy.BaseDataCopyHandler;
import kd.tmc.fpm.business.service.fundsys.copy.model.BaseDataCopyContext;

public class DimAndMemberMapCopyHandler
extends BaseDataCopyHandler {
    private static Log logger = LogFactory.getLog(DimAndMemberMapCopyHandler.class);

    @Override
    public void handler() {
        BaseDataCopyContext.CopyBaseDataInfo fundSysInfo = this.context.getCopyBDInfoS("fpm_bodysysmanage").get(0);
        Long oldSystemId = fundSysInfo.getOldId();
        ArrayList<BaseDataCopyContext.CopyBaseDataInfo> copyBDInfoS = new ArrayList<BaseDataCopyContext.CopyBaseDataInfo>();
        DynamicObjectCollection dataColl = QueryServiceHelper.query((String)"fpm_dimensionmember", (String)"id", (QFilter[])new QFilter[]{new QFilter(String.join((CharSequence)".", "bodysysmanage", "id"), "=", (Object)oldSystemId), new QFilter("enable", "=", (Object)"1")});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dataColl)) {
            List idList = dataColl.stream().map(e -> e.get("id")).collect(Collectors.toList());
            DynamicObject[] dimMembers = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_dimensionmember"));
            DynamicObject bSysManage = (DynamicObject)fundSysInfo.getNewObj();
            List<BaseDataCopyContext.CopyBaseDataInfo> dimensionInfoS = this.context.getCopyBDInfoS("fpm_dimension");
            List<BaseDataCopyContext.CopyBaseDataInfo> memberInfoS = this.context.getCopyBDInfoS("fpm_member");
            DynamicObject user = TmcDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(dimMembers.length);
            long[] globalLongIds = DB.genGlobalLongIds((int)dimMembers.length);
            for (int i = 0; i < dimMembers.length; ++i) {
                DynamicObject oldDimMember = dimMembers[i];
                Optional<BaseDataCopyContext.CopyBaseDataInfo> dimensionOptional = dimensionInfoS.stream().filter(c -> c.getOldId().equals(oldDimMember.getLong(String.join((CharSequence)".", "dimension", "id")))).findFirst();
                if (!dimensionOptional.isPresent()) {
                    logger.info("\u539f\u7ef4\u5ea6\u7ba1\u7406[{}]\u83b7\u53d6\u4e0d\u5230\u65b0\u751f\u6210\u7684\u7ef4\u5ea6\u7ba1\u7406", (Object)oldDimMember.getLong(String.join((CharSequence)".", "dimension", "id")));
                    continue;
                }
                long globalLongId = globalLongIds[i];
                DynamicObject newDO = TmcDataServiceHelper.newDynamicObject((String)"fpm_dimensionmember");
                DynamicObjectUtil.copy((DynamicObject)oldDimMember, (DynamicObject)newDO, (String[])new String[]{"id", "bodysysmanage", "number", "createtime", "creator", "modifytime", "modifier", "masterid"});
                newDO.set("id", (Object)globalLongId);
                DynamicObject dimensionNew = TmcDataServiceHelper.loadSingle((Object)dimensionOptional.get().getNewId(), (String)"fpm_dimension");
                newDO.set("dimension", (Object)dimensionNew);
                DynamicObjectCollection entryEntity = newDO.getDynamicObjectCollection("entryentity");
                for (DynamicObject entity : entryEntity) {
                    Optional<BaseDataCopyContext.CopyBaseDataInfo> dimMemberOptional = memberInfoS.stream().filter(c -> c.getOldId().equals(entity.getLong(String.join((CharSequence)".", "dimmember", "id")))).findFirst();
                    if (!dimMemberOptional.isPresent()) {
                        logger.info("\u539f\u7ef4\u5ea6\u6210\u5458\u7ba1\u7406[{}]\u83b7\u53d6\u4e0d\u5230\u65b0\u751f\u6210\u7684\u7ef4\u5ea6\u6210\u5458\u7ba1\u7406", (Object)entity.getLong(String.join((CharSequence)".", "dimmember", "id")));
                        continue;
                    }
                    DynamicObject dimMemberNew = TmcDataServiceHelper.loadSingle((Object)dimMemberOptional.get().getNewId(), (String)"fpm_member");
                    entity.set("dimmember", (Object)dimMemberNew);
                }
                newDO.set("bodysysmanage", (Object)bSysManage);
                newDO.set("creator", (Object)user);
                newDO.set("number", (Object)CodeRuleHelper.generateNumber((String)"fpm_dimensionmember", (DynamicObject)newDO, null, (String)""));
                saveList.add(newDO);
                BaseDataCopyContext.CopyBaseDataInfo copyBaseDataInfo = new BaseDataCopyContext.CopyBaseDataInfo();
                copyBaseDataInfo.setOldId((Long)oldDimMember.getPkValue());
                copyBaseDataInfo.setNewId(globalLongId);
                copyBDInfoS.add(copyBaseDataInfo);
            }
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
        this.context.setCopyBDInfoS("fpm_dimensionmember", copyBDInfoS);
        ArrayList<BaseDataCopyContext.CopyBaseDataInfo> copyBDInfoS1 = new ArrayList<BaseDataCopyContext.CopyBaseDataInfo>();
        Object[] auxiliaryS = TmcDataServiceHelper.load((String)"fpm_auxiliaryfields", (String)"id", (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)oldSystemId)});
        if (EmptyUtil.isNoEmpty((Object[])auxiliaryS)) {
            List idList = Arrays.stream(auxiliaryS).map(e -> e.get("id")).collect(Collectors.toList());
            auxiliaryS = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_auxiliaryfields"));
            DynamicObject bSysManage = (DynamicObject)fundSysInfo.getNewObj();
            for (Object auxiliary : auxiliaryS) {
                DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"fpm_auxiliaryfields");
                DynamicObjectUtil.copy((DynamicObject)auxiliary, (DynamicObject)newDyn, (String[])new String[]{"id", "bodysys", "createtime", "creator", "modifytime", "modifier", "masterid"});
                newDyn.set("bodysys", (Object)bSysManage);
                DynamicObject user = TmcDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
                newDyn.set("creator", (Object)user);
                newDyn.set("createtime", (Object)new Date());
                newDyn.set("number", (Object)CodeRuleHelper.generateNumber((String)"fpm_bodysysmanage", (DynamicObject)newDyn, null, (String)""));
                Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDyn});
                if (EmptyUtil.isEmpty((Object)save[0])) continue;
                BaseDataCopyContext.CopyBaseDataInfo copyBaseDataInfo = new BaseDataCopyContext.CopyBaseDataInfo();
                copyBaseDataInfo.setOldId((Long)auxiliary.getPkValue());
                copyBaseDataInfo.setNewId(((DynamicObject)save[0]).getLong("id"));
                copyBDInfoS1.add(copyBaseDataInfo);
            }
        }
        this.context.setCopyBDInfoS("fpm_auxiliaryfields", copyBDInfoS1);
    }
}

