/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.copy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.DynamicObjectUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.copy.BaseDataCopyHandler;
import kd.tmc.fpm.business.service.fundsys.copy.model.BaseDataCopyContext;
import kd.tmc.fpm.common.enums.DimsionEnums;
import org.apache.commons.collections.CollectionUtils;

public class DimCopyHandler
extends BaseDataCopyHandler {
    @Override
    public void handler() {
        BaseDataCopyContext.CopyBaseDataInfo fundSysInfo = this.context.getCopyBDInfoS("fpm_bodysysmanage").get(0);
        Long oldSystemId = fundSysInfo.getOldId();
        QFilter[] qFilters = new QFilter[]{new QFilter(String.join((CharSequence)".", "bodysystem", "id"), "=", (Object)oldSystemId)};
        DynamicObjectCollection dimenIdColl = QueryServiceHelper.query((String)"fpm_dimension", (String)"id", (QFilter[])qFilters);
        ArrayList<BaseDataCopyContext.CopyBaseDataInfo> copyBDInfoS = new ArrayList<BaseDataCopyContext.CopyBaseDataInfo>();
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dimenIdColl)) {
            List idList = dimenIdColl.stream().map(e -> e.get("id")).collect(Collectors.toList());
            DynamicObject[] dimColl = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_dimension"));
            DynamicObject bSysManage = (DynamicObject)fundSysInfo.getNewObj();
            List<DynamicObject> dimList = Arrays.stream(dimColl).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(dimList)) {
                return;
            }
            this.copyDim(copyBDInfoS, bSysManage, this.getDimByType(dimList, DimsionEnums.ORG));
            this.copyDim(copyBDInfoS, bSysManage, this.getDimByType(dimList, DimsionEnums.CURRENCY));
            this.copyDim(copyBDInfoS, bSysManage, this.getDimByType(dimList, DimsionEnums.PERIOD));
            this.copyDim(copyBDInfoS, bSysManage, this.getDimByType(dimList, DimsionEnums.SUBJECT));
            this.copyDim(copyBDInfoS, bSysManage, this.getDimByType(dimList, DimsionEnums.METRIC));
            List<DynamicObject> otherDims = dimList.stream().filter(item -> {
                String type = item.getString("basedata");
                return !DimsionEnums.ORG.getNumber().equals(type) && !DimsionEnums.CURRENCY.getNumber().equals(type) && !DimsionEnums.PERIOD.getNumber().equals(type) && !DimsionEnums.SUBJECT.getNumber().equals(type) && !DimsionEnums.METRIC.getNumber().equals(type);
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(otherDims)) {
                otherDims.forEach(item -> this.copyDim((List<BaseDataCopyContext.CopyBaseDataInfo>)copyBDInfoS, bSysManage, (DynamicObject)item));
            }
        }
        this.context.setCopyBDInfoS("fpm_dimension", copyBDInfoS);
    }

    private DynamicObject getDimByType(List<DynamicObject> dimList, DimsionEnums dimsionEnums) {
        List orgDim = dimList.stream().filter(item -> dimsionEnums.getNumber().equals(item.getString("basedata"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgDim)) {
            return (DynamicObject)orgDim.get(0);
        }
        return null;
    }

    private void copyDim(List<BaseDataCopyContext.CopyBaseDataInfo> copyBDInfoS, DynamicObject bSysManage, DynamicObject dim) {
        if (Objects.isNull(dim)) {
            return;
        }
        DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"fpm_dimension");
        DynamicObjectUtil.copy((DynamicObject)dim, (DynamicObject)newDyn, (String[])new String[]{"id", "bodysystem", "createtime", "creator", "modifytime", "modifier", "masterid"});
        newDyn.set("bodysystem", (Object)bSysManage);
        newDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
        newDyn.set("createtime", (Object)new Date());
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDyn});
        if (EmptyUtil.isEmpty((Object)save[0])) {
            return;
        }
        BaseDataCopyContext.CopyBaseDataInfo copyBaseDataInfo = new BaseDataCopyContext.CopyBaseDataInfo();
        copyBaseDataInfo.setOldId((Long)dim.getPkValue());
        copyBaseDataInfo.setNewId(((DynamicObject)save[0]).getLong("id"));
        copyBDInfoS.add(copyBaseDataInfo);
    }
}

