/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.copy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DynamicObjectUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.service.fundsys.copy.BaseDataCopyHandler;
import kd.tmc.fpm.business.service.fundsys.copy.model.BaseDataCopyContext;

public class DimMemberCopyHandler
extends BaseDataCopyHandler {
    private static Log logger = LogFactory.getLog(DimMemberCopyHandler.class);

    @Override
    public void handler() {
        BaseDataCopyContext.CopyBaseDataInfo fundSysInfo = this.context.getCopyBDInfoS("fpm_bodysysmanage").get(0);
        Long oldSystemId = fundSysInfo.getOldId();
        DynamicObjectCollection oldSystemMembers = QueryServiceHelper.query((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)oldSystemId)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)oldSystemMembers)) {
            return;
        }
        ArrayList<BaseDataCopyContext.CopyBaseDataInfo> copyBDInfoS = new ArrayList<BaseDataCopyContext.CopyBaseDataInfo>();
        List idList = oldSystemMembers.stream().map(e -> e.get("id")).collect(Collectors.toList());
        DynamicObject[] dimMenberColl = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_member"));
        DynamicObject bSysManage = (DynamicObject)fundSysInfo.getNewObj();
        List<BaseDataCopyContext.CopyBaseDataInfo> dimensionInfos = this.context.getCopyBDInfoS("fpm_dimension");
        Map oldDimMap = dimensionInfos.stream().collect(Collectors.toMap(BaseDataCopyContext.CopyBaseDataInfo::getOldId, Function.identity()));
        List<Object> newDimIdMap = oldDimMap.values().stream().map(BaseDataCopyContext.CopyBaseDataInfo::getNewId).filter(Objects::nonNull).collect(Collectors.toList());
        DynamicObject[] newDimObjs = BusinessDataServiceHelper.load((Object[])newDimIdMap.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_dimension"));
        Map dimMap = Arrays.stream(newDimObjs).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(dimMenberColl.length);
        long[] globalLongIds = DB.genGlobalLongIds((int)dimMenberColl.length);
        HashMap<Long, DynamicObject> oldNewPkIdMap = new HashMap<Long, DynamicObject>(dimMenberColl.length);
        Object[] newPkIds = new Long[dimMenberColl.length];
        DynamicObject user = TmcDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        for (int i = 0; i < dimMenberColl.length; ++i) {
            DynamicObject dimMen = dimMenberColl[i];
            long dimId = dimMen.getLong(String.join((CharSequence)".", "dimension", "id"));
            BaseDataCopyContext.CopyBaseDataInfo oldDimInfo = (BaseDataCopyContext.CopyBaseDataInfo)oldDimMap.get(dimId);
            if (Objects.isNull(oldDimInfo)) {
                logger.info("\u539f\u7ef4\u5ea6\u7ba1\u7406[{}]\u83b7\u53d6\u4e0d\u5230\u65b0\u751f\u6210\u7684\u7ef4\u5ea6\u7ba1\u7406", (Object)dimMen.getLong(String.join((CharSequence)".", "dimension", "id")));
                continue;
            }
            if (DimensionType.PERIOD.getNumber().equals(dimMen.getString("dimtype"))) continue;
            long globalLongId = globalLongIds[i];
            DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"fpm_member");
            DynamicObjectUtil.copy((DynamicObject)dimMen, (DynamicObject)newDyn, (String[])new String[]{"id", "bodysystem", "createtime", "creator", "modifytime", "modifier", "masterid"});
            newDyn.set("id", (Object)globalLongId);
            newDyn.set("bodysystem", (Object)bSysManage);
            newDyn.set("name", dimMen.get("name"));
            if (DimensionType.SUBJECTS.getNumber().equals(newDyn.getString("dimtype"))) {
                newDyn.set("bodysysmanage", (Object)bSysManage);
            }
            newDyn.set("creator", (Object)user);
            DynamicObject newDim = (DynamicObject)dimMap.get(oldDimInfo.getNewId());
            newDyn.set("dimension", (Object)newDim);
            saveList.add(newDyn);
            BaseDataCopyContext.CopyBaseDataInfo copyBaseDataInfo = new BaseDataCopyContext.CopyBaseDataInfo();
            copyBaseDataInfo.setOldId((Long)dimMen.getPkValue());
            copyBaseDataInfo.setNewId(globalLongId);
            copyBDInfoS.add(copyBaseDataInfo);
            oldNewPkIdMap.put((Long)dimMen.getPkValue(), newDyn);
            newPkIds[i] = globalLongId;
        }
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        DynamicObject[] newDimMembers = TmcDataServiceHelper.load((Object[])newPkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_member"));
        Arrays.stream(newDimMembers).forEach(c -> {
            if (EmptyUtil.isNoEmpty((DynamicObject)c.getDynamicObject("parent"))) {
                DynamicObject parent = c.getDynamicObject("parent");
                c.set("parent", oldNewPkIdMap.get(parent.getLong("id")));
            }
            if (DimensionType.SUBJECTS.getNumber().equals(c.getString("dimtype"))) {
                Long linkSubjectId;
                if (EmptyUtil.isNoEmpty((String)c.getString("formulavalue"))) {
                    String formula = c.getString("formulavalue");
                    Set<String> subjectIds = this.getSubjectIdByFormula(formula);
                    for (String subjectId : subjectIds) {
                        Long subjectid = Long.parseLong(subjectId);
                        if (!EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)oldNewPkIdMap.get(subjectid)))) continue;
                        formula = formula.replaceAll(subjectId, ((DynamicObject)oldNewPkIdMap.get(subjectid)).getString("id"));
                    }
                    c.set("formulavalue", (Object)formula);
                    c.set("formulavalue_tag", (Object)formula);
                }
                if (c.getDynamicObject("linksubject") != null && oldNewPkIdMap.containsKey(linkSubjectId = (Long)c.getDynamicObject("linksubject").getPkValue())) {
                    c.set("linksubject", oldNewPkIdMap.get(linkSubjectId));
                }
            }
        });
        SaveServiceHelper.save((DynamicObject[])newDimMembers);
        this.context.setCopyBDInfoS("fpm_member", copyBDInfoS);
    }

    private Set<String> getSubjectIdByFormula(String formula) {
        String[] expressUnits;
        HashSet<String> subjectIds = new HashSet<String>();
        String isDigitalRegex = "^[0-9]*$";
        String isDoubleBracketRegex = "^(\\[)[0-9]*(\\])$";
        String regex = "\\+|\\-";
        for (String expressUnit : expressUnits = formula.split(regex)) {
            boolean isDoubleBracket;
            boolean isDigit = expressUnit.matches(isDigitalRegex);
            if (isDigit || !(isDoubleBracket = expressUnit.matches(isDoubleBracketRegex))) continue;
            subjectIds.add(Optional.of(expressUnit).map(o -> o.replaceAll("\\[|]", "")).orElseGet(() -> ""));
        }
        return subjectIds;
    }
}

