/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.copy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DynamicObjectUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.copy.BaseDataCopyHandler;
import kd.tmc.fpm.business.service.fundsys.copy.model.BaseDataCopyContext;
import kd.tmc.fpm.common.bean.CurrencyMapConfig;
import org.apache.commons.collections4.MapUtils;

public class SummaryConfigCopyHandler
extends BaseDataCopyHandler {
    private static Log logger = LogFactory.getLog(SummaryConfigCopyHandler.class);

    @Override
    public void handler() {
        BaseDataCopyContext.CopyBaseDataInfo fundSysInfo = this.context.getCopyBDInfoS("fpm_bodysysmanage").get(0);
        Long oldSystemId = fundSysInfo.getOldId();
        ArrayList<BaseDataCopyContext.CopyBaseDataInfo> copyBDInfos = new ArrayList<BaseDataCopyContext.CopyBaseDataInfo>();
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"fpm_summaryconfig", (QFilter[])new QFilter[]{new QFilter(String.join((CharSequence)".", "bodysys", "id"), "=", (Object)oldSystemId)}, null, (int)-1);
        if (EmptyUtil.isNoEmpty((Object)idList)) {
            DynamicObject[] oldDataArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_summaryconfig"));
            DynamicObject bodySys = TmcDataServiceHelper.loadSingle((Object)fundSysInfo.getNewId(), (String)"fpm_bodysysmanage");
            List<BaseDataCopyContext.CopyBaseDataInfo> memberInfos = this.context.getCopyBDInfoS("fpm_member");
            Map<Long, Long> memberIdMap = memberInfos.stream().collect(Collectors.toMap(BaseDataCopyContext.CopyBaseDataInfo::getOldId, BaseDataCopyContext.CopyBaseDataInfo::getNewId, (key1, key2) -> key2));
            for (DynamicObject oldData : oldDataArr) {
                DynamicObject newData = TmcDataServiceHelper.newDynamicObject((String)"fpm_summaryconfig");
                DynamicObjectUtil.copy((DynamicObject)oldData, (DynamicObject)newData, (String[])new String[]{"id", "bodysys", "number", "createtime", "creator", "modifytime", "modifier"});
                DynamicObjectCollection entryEntity = newData.getDynamicObjectCollection("treeentryentity");
                DynamicObjectCollection oldEntryEntity = oldData.getDynamicObjectCollection("treeentryentity");
                entryEntity.sort(Comparator.comparing(o -> o.getBigDecimal("seq")));
                oldEntryEntity.sort(Comparator.comparing(o -> o.getBigDecimal("seq")));
                HashMap<Long, Long> treeIdMap = new HashMap<Long, Long>(2);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject entity = (DynamicObject)entryEntity.get(i);
                    DynamicObject oldEntity = (DynamicObject)oldEntryEntity.get(i);
                    Long id = DBServiceHelper.genLongIds((String)"t_fpm_summarymainparam", (int)1)[0];
                    entity.set("id", (Object)id);
                    Long newMemberId = memberIdMap.get(entity.getLong(String.join((CharSequence)".", "sum_reportorg", "id")));
                    if (EmptyUtil.isEmpty((Long)newMemberId)) {
                        logger.info("\u539f\u7ef4\u5ea6\u6210\u5458\u7ba1\u7406[{}]\u83b7\u53d6\u4e0d\u5230\u65b0\u751f\u6210\u7684\u7ef4\u5ea6\u6210\u5458\u7ba1\u7406", (Object)entity.getLong(String.join((CharSequence)".", "sum_reportorg", "id")));
                        continue;
                    }
                    DynamicObject memberNew = TmcDataServiceHelper.loadSingle((Object)newMemberId, (String)"fpm_member");
                    entity.set("sum_reportorg", (Object)memberNew);
                    if (MapUtils.isNotEmpty(treeIdMap)) {
                        entity.set("pid", treeIdMap.get(entity.getLong("pid")));
                    }
                    treeIdMap.put(oldEntity.getLong("id"), id);
                    String currencyMapCaseJson = oldEntity.getString("sum_currencymapcasereal_tag");
                    if (!EmptyUtil.isNoEmpty((String)currencyMapCaseJson)) continue;
                    CurrencyMapConfig currencyMapConfig = (CurrencyMapConfig)SerializationUtils.fromJsonString((String)currencyMapCaseJson, CurrencyMapConfig.class);
                    currencyMapConfig.setBodySysId(fundSysInfo.getNewId());
                    currencyMapConfig.getMapConfigList().stream().forEach(c -> {
                        c.setSumCurrencyMemberId((Long)memberIdMap.get(c.getSumCurrencyMemberId()));
                        ArrayList subOrgReportCurrencyIds = new ArrayList(2);
                        c.getSubMainReportCurrencyId().stream().forEach(subMainId -> subOrgReportCurrencyIds.add(memberIdMap.get(subMainId)));
                        c.setSubMainReportCurrencyId(subOrgReportCurrencyIds);
                    });
                    entity.set("sum_currencymapcasereal_tag", (Object)SerializationUtils.toJsonString((Object)currencyMapConfig));
                }
                newData.set("bodysys", (Object)bodySys);
                DynamicObject user = TmcDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
                newData.set("creator", (Object)user);
                newData.set("number", (Object)CodeRuleHelper.generateNumber((String)"fpm_summaryconfig", (DynamicObject)newData, null, (String)""));
                Object[] saveOp = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newData});
                if (EmptyUtil.isEmpty((Object[])saveOp)) continue;
                BaseDataCopyContext.CopyBaseDataInfo copyBaseDataInfo = new BaseDataCopyContext.CopyBaseDataInfo();
                copyBaseDataInfo.setOldId((Long)oldData.getPkValue());
                copyBaseDataInfo.setNewId(((DynamicObject)saveOp[0]).getLong("id"));
                copyBDInfos.add(copyBaseDataInfo);
            }
        }
        this.context.setCopyBDInfoS("fpm_summaryconfig", copyBDInfos);
    }
}

