/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.context;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.exportandimport.idpool.BodySystemImportIdPool;
import org.apache.commons.collections4.MapUtils;

public class BodySysImportContext {
    private BodySystemImportIdPool bodySystemImportIdPool;
    private final Map<Long, Long> dutyOrgMemberMap;
    private final Map<String, Set<String>> errorMsgMap;
    private String currentImportFile;

    public BodySysImportContext(BodySystemImportIdPool bodySystemImportIdPool) {
        this.bodySystemImportIdPool = bodySystemImportIdPool;
        this.dutyOrgMemberMap = new HashMap<Long, Long>(16);
        this.errorMsgMap = new HashMap<String, Set<String>>(16);
    }

    public BodySystemImportIdPool getBodySystemImportIdPool() {
        return this.bodySystemImportIdPool;
    }

    public void setBodySystemImportIdPool(BodySystemImportIdPool bodySystemImportIdPool) {
        this.bodySystemImportIdPool = bodySystemImportIdPool;
    }

    public Long getDutyOrgMemberId(Long bodySysId) {
        return this.dutyOrgMemberMap.getOrDefault(bodySysId, 0L);
    }

    public void register(Long systemId, Long dutyOrgMemberId) {
        this.dutyOrgMemberMap.putIfAbsent(systemId, dutyOrgMemberId);
    }

    public String getCurrentImportFile() {
        return this.currentImportFile;
    }

    public void switchImportFile(String currentImportFile) {
        this.currentImportFile = currentImportFile;
        this.bodySystemImportIdPool.clear();
    }

    public void addErrorMsg(String errorMsg) {
        if (EmptyUtil.isEmpty((String)errorMsg)) {
            return;
        }
        if (EmptyUtil.isEmpty((String)this.currentImportFile)) {
            return;
        }
        Set errorMsgSet = this.errorMsgMap.computeIfAbsent(this.currentImportFile, k -> new LinkedHashSet(16));
        errorMsgSet.add(errorMsg);
    }

    public String getErrorMsg(String url) {
        Set<String> strings = this.errorMsgMap.get(url);
        if (EmptyUtil.isEmpty(strings)) {
            return "";
        }
        return String.join((CharSequence)";", strings);
    }

    public boolean hasError() {
        return MapUtils.isNotEmpty(this.errorMsgMap);
    }
}

