/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.exportandimport.config.BodySystemExportAndImportConfig;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.IBodySystemImportHandler;
import kd.tmc.fpm.business.service.fundsys.exportandimport.idpool.BodySystemImportIdPool;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.olap.enums.ShrekSyncStatus;

public abstract class AbstractBodySystemImportHandler
implements IBodySystemImportHandler {
    protected BodySystemImportIdPool bodySystemImportIdPool;
    protected BodySysImportContext bodySysImportContext;
    private static final Pattern compile = Pattern.compile("(\\[)([0-9]+)(\\])");
    private static final Log logger = LogFactory.getLog(AbstractBodySystemImportHandler.class);

    public AbstractBodySystemImportHandler(BodySysImportContext bodySysImportContext) {
        this.bodySysImportContext = bodySysImportContext;
        this.bodySystemImportIdPool = bodySysImportContext.getBodySystemImportIdPool();
    }

    @Override
    public void handler(List<DynamicObject> dynamicObjectList) {
        try (TXHandle tx = TX.required();){
            try {
                this.beforeHandler(dynamicObjectList);
                for (DynamicObject dynamicObject : dynamicObjectList) {
                    if (this.skip(dynamicObject)) continue;
                    DynamicObject clone = TmcDataServiceHelper.clone((DynamicObject)dynamicObject);
                    this.doHandler(clone, dynamicObject);
                }
                this.afterHandler(dynamicObjectList);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(e.getMessage(), (Throwable)e);
                if (this.abort()) {
                    throw e;
                }
                this.bodySysImportContext.addErrorMsg(String.join((CharSequence)":", this.getHandleEntity(), e.getMessage()));
            }
        }
    }

    protected void beforeHandler(List<DynamicObject> dynamicObjectList) {
    }

    protected void afterHandler(List<DynamicObject> dynamicObjectList) {
        List<DynamicObject> allDynamicObjectList = this.getIdPool().getAllNewDynamicObjectList();
        SaveServiceHelper.save((DynamicObject[])allDynamicObjectList.toArray(new DynamicObject[0]));
    }

    protected void register(Long oldId, DynamicObject dynamicObject) {
        this.registerAndResetNumberIfNeed(oldId, dynamicObject, false);
    }

    protected void registerAndResetNumber(Long oldId, DynamicObject dynamicObject) {
        this.registerAndResetNumberIfNeed(oldId, dynamicObject, true);
    }

    protected void registerAndResetNumberIfNeed(Long oldId, DynamicObject dynamicObject, boolean resetNumber) {
        this.bodySystemImportIdPool.register(oldId, dynamicObject);
        if (resetNumber) {
            String number = CodeRuleHelper.generateNumber((String)this.getHandleEntity(), (DynamicObject)dynamicObject, null, null);
            dynamicObject.set("number", (Object)number);
        }
    }

    protected abstract void doHandler(DynamicObject var1, DynamicObject var2);

    protected boolean skip(DynamicObject dynamicObject) {
        return false;
    }

    protected void resetProp(DynamicObject dynamicObject) {
        Map<String, EntityType> allEntities = this.getAllEntities();
        for (Map.Entry<String, EntityType> entry : allEntities.entrySet()) {
            EntityType entityType = entry.getValue();
            DataEntityPropertyCollection properties = entityType.getProperties();
            DynamicObjectCollection waitReset = Objects.equals(this.getHandleEntity(), entry.getKey()) ? Collections.singletonList(dynamicObject) : dynamicObject.getDynamicObjectCollection(entry.getKey());
            for (DynamicObject restDy : waitReset) {
                for (IDataEntityProperty dataEntityProperty : properties) {
                    this.doReset(restDy, dataEntityProperty);
                }
            }
        }
    }

    protected void doReset(DynamicObject restDy, IDataEntityProperty dataEntityProperty) {
        if (this.isSkipProperty(dataEntityProperty)) {
            return;
        }
        if (this.isShouldSetDefault(restDy, dataEntityProperty)) {
            return;
        }
        if (BodySystemExportAndImportConfig.getShrekSyncStatus().contains(dataEntityProperty.getName())) {
            dataEntityProperty.setValueFast((Object)restDy, (Object)ShrekSyncStatus.WAIT_SYNC.name());
            return;
        }
        if (Objects.equals("shrekdatakey", dataEntityProperty.getName())) {
            dataEntityProperty.setValueFast((Object)restDy, (Object)"");
            return;
        }
        if (dataEntityProperty instanceof MulBasedataProp) {
            DynamicObjectCollection dynamicObjectCollection = restDy.getDynamicObjectCollection(dataEntityProperty);
            this.getNewMultiSelectBaseDataDc(dynamicObjectCollection);
            return;
        }
        if (dataEntityProperty instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)dataEntityProperty;
            if (BodySystemExportAndImportConfig.getExportEntities().contains(basedataProp.getBaseEntityId())) {
                DynamicObject dynamicObject = restDy.getDynamicObject(dataEntityProperty);
                if (Objects.isNull(dynamicObject)) {
                    return;
                }
                DynamicObject newBaeDataDy = this.getNewBaeDataDy(dynamicObject);
                dataEntityProperty.setValueFast((Object)restDy, (Object)newBaeDataDy);
            }
        }
    }

    protected boolean isShouldSetDefault(DynamicObject restDy, IDataEntityProperty dataEntityProperty) {
        boolean result = false;
        if (this.isClearProp(dataEntityProperty)) {
            dataEntityProperty.setValueFast((Object)restDy, null);
            result = true;
        }
        if (Objects.equals(dataEntityProperty.getName(), "creator")) {
            dataEntityProperty.setValueFast((Object)restDy, (Object)this.newDynamicObject("bos_user", RequestContext.get().getCurrUserId()));
            return true;
        }
        if (Objects.equals(dataEntityProperty.getName(), "createtime")) {
            dataEntityProperty.setValueFast((Object)restDy, (Object)DateUtils.getCurrentTime());
            return true;
        }
        return result;
    }

    protected boolean isClearProp(IDataEntityProperty dataEntityProperty) {
        if (dataEntityProperty instanceof DateProp) {
            return true;
        }
        return dataEntityProperty instanceof UserProp;
    }

    protected void getNewMultiSelectBaseDataDc(DynamicObjectCollection dynamicObjectCollection) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject data = dynamicObject.getDynamicObject("fbasedataid");
            DynamicObject newBaeDataDy = this.getNewBaeDataDy(data);
            dynamicObject.set("fbasedataid", (Object)newBaeDataDy);
            dynamicObject.set("fbasedataid_id", newBaeDataDy.get("id"));
        }
    }

    protected boolean isSkipProperty(IDataEntityProperty dataEntityProperty) {
        return false;
    }

    protected DynamicObject getNewBaeDataDy(DynamicObject dynamicObject) {
        long id;
        String name = dynamicObject.getDataEntityType().getName();
        if (!BodySystemExportAndImportConfig.getExportEntities().contains(name)) {
            return this.newDynamicObject(name, dynamicObject.get("id"));
        }
        BodySystemImportIdPool.IdPool idPool = this.bodySystemImportIdPool.getIdPool(name);
        DynamicObject newDy = idPool.getDynamicObject(id = dynamicObject.getLong("id"));
        if (Objects.nonNull(newDy)) {
            return TmcDataServiceHelper.loadSingle((Object)id, (String)name);
        }
        Long newId = idPool.getId(id);
        if (EmptyUtil.isEmpty((Long)newId)) {
            StringBuilder sb = new StringBuilder();
            sb.append(name).append("#").append(dynamicObject.getString("name")).append(ResManager.loadKDString((String)"\u672a\u5bfc\u5165\u3002", (String)"AbstractBodySystemImportHandler_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            throw new KDBizException(sb.toString());
        }
        newDy = idPool.getDynamicObject(newId);
        if (Objects.nonNull(newDy)) {
            return newDy;
        }
        return this.newDynamicObject(name, newId);
    }

    protected Map<String, EntityType> getAllEntities() {
        String handleEntity = this.getHandleEntity();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)handleEntity);
        Map allEntities = dataEntityType.getAllEntities();
        return allEntities.entrySet().stream().filter(entry -> !(entry.getValue() instanceof LinkEntryType)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected boolean abort() {
        return false;
    }

    protected DynamicObject newDynamicObject(String type, Object id) {
        DynamicObject dynamicObject;
        DynamicObject dynamicObject2 = dynamicObject = id instanceof Long ? this.getIdPool().getDynamicObject((Long)id) : null;
        if (Objects.isNull(dynamicObject)) {
            dynamicObject = TmcDataServiceHelper.newDynamicObject((String)type);
            dynamicObject.set("id", id);
        }
        return dynamicObject;
    }

    protected BodySystemImportIdPool.IdPool getIdPool() {
        return this.bodySystemImportIdPool.register(this.getHandleEntity());
    }

    protected Long getId(DynamicObject dynamicObject) {
        return dynamicObject.getLong("id");
    }

    protected String getNewFormulaValue(String oldFormulaValue, String entityName) {
        if (EmptyUtil.isEmpty((String)StringHelper.getStringValue((Object)oldFormulaValue))) {
            return oldFormulaValue;
        }
        String newFormulaValue = oldFormulaValue;
        Matcher matcher = compile.matcher(oldFormulaValue);
        while (matcher.find()) {
            String oldSubjectId = matcher.group(2);
            Long newSubjectId = this.bodySystemImportIdPool.getIdPool(entityName).getId(Long.parseLong(oldSubjectId));
            if (EmptyUtil.isEmpty((Long)newSubjectId)) {
                StringBuilder sb = new StringBuilder();
                sb.append(entityName).append("#").append(oldFormulaValue).append("id:").append(oldSubjectId).append(ResManager.loadKDString((String)"\u672a\u5bfc\u5165\u3002", (String)"AbstractBodySystemImportHandler_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                throw new KDBizException(sb.toString());
            }
            newFormulaValue = newFormulaValue.replace(oldSubjectId, newSubjectId.toString());
        }
        return newFormulaValue;
    }

    protected void cleanProp(DynamicObject dynamicObject, String ... propName) {
        if (propName == null || propName.length == 0) {
            return;
        }
        for (String prop : propName) {
            dynamicObject.set(prop, null);
        }
    }

    protected void cleanEntry(DynamicObject dynamicObject, String ... entryNames) {
        if (entryNames == null || entryNames.length == 0) {
            return;
        }
        for (String entryName : entryNames) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryName);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) continue;
            dynamicObjectCollection.clear();
        }
    }

    static class NewDynamicObjectBuilder {
        private DynamicObject dynamicObject;

        public NewDynamicObjectBuilder(DynamicObject dynamicObject) {
            this.dynamicObject = dynamicObject;
        }

        public NewDynamicObjectBuilder setValue(String prop, Object value) {
            this.dynamicObject.set(prop, value);
            return this;
        }

        public DynamicObject build() {
            return this.dynamicObject;
        }
    }
}

