/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.bodysysimport.BodySysImportInfo;
import kd.tmc.fpm.business.service.fundsys.exportandimport.config.BodySystemExportAndImportConfig;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;
import kd.tmc.fpm.business.service.fundsys.exportandimport.idpool.BodySystemImportIdPool;
import kd.tmc.fpm.business.service.fundsys.exportandimport.mapper.DynamicObjectMapper;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class BodySysImportHandlerImpl
extends AbstractBodySystemImportHandler {
    private static final Log logger = LogFactory.getLog(BodySysImportHandlerImpl.class);
    private final BodySysImportInfo bodySysImportInfo;
    private final IDataSaveService dataSaveService;
    private DynamicObjectMapper dynamicObjectMapper;

    public BodySysImportHandlerImpl(BodySysImportContext bodySysImportContext, BodySysImportInfo bodySysImportInfo) {
        super(bodySysImportContext);
        this.bodySysImportInfo = bodySysImportInfo;
        this.dataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject dynamicObject) {
        this.registerAndResetNumber(dynamicObject.getLong("id"), clone);
        this.checkAndSet(clone);
        this.setNotMustInputIfNeed(clone);
        this.createReportTypeIfNeed(clone);
        this.resetProp(clone);
        this.clearNotImport(clone);
    }

    @Override
    protected boolean isSkipProperty(IDataEntityProperty dataEntityProperty) {
        return !Objects.equals(dataEntityProperty.getName(), "rerporttype") && !BodySystemExportAndImportConfig.getShrekSyncStatus().contains(dataEntityProperty.getName());
    }

    private void clearNotImport(DynamicObject dynamicObject) {
        dynamicObject.getDynamicObjectCollection("manageentry").clear();
        dynamicObject.set("creatormanage", (Object)this.newDynamicObject("bos_user", RequestContext.get().getCurrUserId()));
        dynamicObject.set("usergroupmanage", null);
        dynamicObject.set("usermanage", null);
    }

    @Override
    protected void beforeHandler(List<DynamicObject> dynamicObjectList) {
        this.dynamicObjectMapper = new DynamicObjectMapper(dy -> String.join((CharSequence)"#", dy.getString("orgreportcycle"), dy.getString("orgreporttype")));
        this.dynamicObjectMapper.init("fpm_orgreporttype", new QFilter[0]);
        BodySystemImportIdPool.IdPool idPoll = this.bodySystemImportIdPool.register("fpm_orgreporttype");
        this.dynamicObjectMapper.getDynamicObjectList().forEach(idPoll::registerExists);
    }

    private void createReportTypeIfNeed(DynamicObject dynamicObject) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("applyrereportentry");
        dynamicObjectCollection.removeIf(dy -> !Objects.equals("enable", dy.getString("rereporttypestatus")));
        ArrayList<DynamicObject> waitSave = new ArrayList<DynamicObject>(16);
        ArrayList<Long> update2Enable = new ArrayList<Long>(16);
        for (DynamicObject reportTypeEntry : dynamicObjectCollection) {
            DynamicObject reportType = reportTypeEntry.getDynamicObject("rerporttype");
            long reportTypeOldId = reportType.getLong("id");
            Long id = this.bodySystemImportIdPool.getIdPool("fpm_orgreporttype").getId(reportTypeOldId);
            if (EmptyUtil.isNoEmpty((Long)id)) {
                reportTypeEntry.set("rerporttype", (Object)this.newDynamicObject("fpm_orgreporttype", id));
                continue;
            }
            String key = String.join((CharSequence)"#", reportType.getString("orgreportcycle"), reportType.getString("orgreporttype"));
            DynamicObjectMapper.MapperObjectHolder mapperObjectHolder = this.dynamicObjectMapper.getMapperObjectHolder(key);
            if (mapperObjectHolder == null) {
                DynamicObject clone = TmcDataServiceHelper.clone((DynamicObject)reportType);
                this.bodySystemImportIdPool.register("fpm_orgreporttype").register(reportType.getLong("id"), clone);
                String number = CodeRuleHelper.generateNumber((String)"fpm_orgreporttype", (DynamicObject)clone, null, null);
                clone.set("number", (Object)number);
                waitSave.add(clone);
                logger.info("\u5f53\u524d\u7cfb\u7edf\u4e2d\u6ca1\u6709\u7f16\u62a5\u5468\u671f\u4e3a\uff1a{}\uff0c\u660e\u7ec6\u671f\u95f4\u7c7b\u578b\u4e3a\uff1a{}\u7684\u7f16\u62a5\u7c7b\u578b\uff0c\u65b0\u521b\u5efa\u5bf9\u5e94\u7684\u7f16\u62a5\u7c7b\u578b:{}\u3002", new Object[]{reportType.getString("orgreportcycle"), reportType.getString("orgreporttype"), reportType.getString("name")});
                continue;
            }
            this.bodySystemImportIdPool.register("fpm_orgreporttype").registerNewIdExists(reportTypeOldId, mapperObjectHolder.getDynamicObject());
            reportTypeEntry.set("rerporttype", (Object)this.newDynamicObject("fpm_orgreporttype", mapperObjectHolder.getId()));
            if (mapperObjectHolder.isEnable()) continue;
            update2Enable.add(mapperObjectHolder.getId());
            logger.info("\u5f53\u524d\u7cfb\u7edf\u4e2d\u5b58\u5728\u7f16\u62a5\u5468\u671f\u4e3a\uff1a{}\uff0c\u660e\u7ec6\u671f\u95f4\u7c7b\u578b\u4e3a\uff1a{}\u7684\u7f16\u62a5\u7c7b\u578b:{}\uff0c\u4f46\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u5c06\u66f4\u65b0\u4e3a\u53ef\u7528\u72b6\u6001\u3002", new Object[]{reportType.getString("orgreportcycle"), reportType.getString("orgreporttype"), mapperObjectHolder.getDynamicObject().getString("name")});
        }
        if (EmptyUtil.isNoEmpty(waitSave)) {
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])waitSave.toArray(new DynamicObject[0]));
            }
        }
        if (EmptyUtil.isNoEmpty(update2Enable)) {
            this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_orgreporttype set fenable = '1' where fid=? and fenable='0'", update2Enable, (t, d) -> d.add(t));
        }
    }

    @Override
    protected void afterHandler(List<DynamicObject> dynamicObjectList) {
        List<DynamicObject> allDynamicObjectList = this.getIdPool().getAllNewDynamicObjectList();
        TmcOperateServiceHelper.execOperate((String)"save", (String)this.getHandleEntity(), (DynamicObject[])allDynamicObjectList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        this.setDutyOrgMemberId(allDynamicObjectList);
    }

    private void setDutyOrgMemberId(List<DynamicObject> allDynamicObjectList) {
        DynamicObject[] load;
        if (EmptyUtil.isEmpty(allDynamicObjectList)) {
            return;
        }
        List bodySystemIds = allDynamicObjectList.stream().map(this::getId).collect(Collectors.toList());
        QFilter qFilter = new QFilter("bodysystem", "in", bodySystemIds).and(new QFilter("dimtype", "=", (Object)DimensionType.ORG.getNumber())).and(new QFilter("sourceid", "=", (Object)this.getId(this.bodySysImportInfo.getDutyOrgId())));
        List list = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        if (EmptyUtil.isEmpty((Collection)list)) {
            return;
        }
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_member"))) {
            this.bodySystemImportIdPool.register("fpm_member").registerExists(dynamicObject);
            this.bodySysImportContext.register(this.getId(dynamicObject.getDynamicObject("bodysystem")), this.getId(dynamicObject));
        }
    }

    private void setNotMustInputIfNeed(DynamicObject dynamicObject) {
        this.setDutyCurrency(dynamicObject);
        Long oldRateTableId = this.getId(dynamicObject.getDynamicObject("ratetype"));
        this.setRateTable(dynamicObject);
        this.bodySystemImportIdPool.register("bd_exratetable").registerNewIdExists(oldRateTableId, dynamicObject.getDynamicObject("ratetype"));
    }

    private void setRateTable(DynamicObject dynamicObject) {
        if (EmptyUtil.isNoEmpty((DynamicObject)this.bodySysImportInfo.getRateTableId())) {
            dynamicObject.set("ratetype", (Object)this.bodySysImportInfo.getRateTableId());
            return;
        }
        DynamicObject rate = dynamicObject.getDynamicObject("ratetype");
        List list = QueryServiceHelper.queryPrimaryKeys((String)"bd_exratetable", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)rate.getString("name"))}, null, (int)1);
        if (!EmptyUtil.isNoEmpty((Object)list)) {
            List objectList = QueryServiceHelper.queryPrimaryKeys((String)"bd_exratetable", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)}, null, (int)1);
            if (EmptyUtil.isNoEmpty((Object)objectList)) {
                dynamicObject.set("ratetype", (Object)this.newDynamicObject("bd_exratetable", objectList.get(0)));
                return;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u521b\u5efa\u65b0\u4f53\u7cfb\u3010%1$s\u3011\u5931\u8d25\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u6c47\u7387\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BodySysImportHandlerImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), this.bodySysImportInfo.getBodySysName()));
        }
        dynamicObject.set("ratetype", (Object)this.newDynamicObject("bd_exratetable", list.get(0)));
    }

    private void setDutyCurrency(DynamicObject dynamicObject) {
        if (EmptyUtil.isNoEmpty((DynamicObject)this.bodySysImportInfo.getDutyOrgCurrencyId())) {
            dynamicObject.set("currency", (Object)this.bodySysImportInfo.getDutyOrgCurrencyId());
            return;
        }
        String selectFields = String.join((CharSequence)",", "id", "number", "name");
        String currencyNumber = dynamicObject.getDynamicObject("currency").getString("number");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_currency", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)query)) {
            Map<String, List<DynamicObject>> currencyMap = query.stream().collect(Collectors.groupingBy(dy -> dy.getString("number")));
            DynamicObject currency = currencyMap.getOrDefault(currencyNumber, currencyMap.getOrDefault("CYN", currencyMap.entrySet().iterator().next().getValue())).get(0);
            dynamicObject.set("currency", (Object)new AbstractBodySystemImportHandler.NewDynamicObjectBuilder(this.newDynamicObject("bd_currency", this.getId(currency))).setValue("name", currency.getString("name")).setValue("number", currency.getString("number")).build());
        }
    }

    private void checkAndSet(DynamicObject dynamicObject) {
        if (EmptyUtil.isEmpty((Object)this.bodySysImportInfo.getBodySysName())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u4f53\u7cfb\u5931\u8d25\uff0c\u4f53\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BodySysImportHandlerImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        dynamicObject.set("name", (Object)this.bodySysImportInfo.getBodySysName());
        if (EmptyUtil.isEmpty((DynamicObject)this.bodySysImportInfo.getDutyOrgId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u4f53\u7cfb\u5931\u8d25\uff0c\u8d23\u4efb\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BodySysImportHandlerImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        dynamicObject.set("org", (Object)this.bodySysImportInfo.getDutyOrgId());
    }

    @Override
    protected boolean skip(DynamicObject dynamicObject) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("applyrereportentry");
        Optional<DynamicObject> any = dynamicObjectCollection.stream().filter(dy -> Objects.equals(dy.getString("rereporttypestatus"), "enable")).findAny();
        if (!any.isPresent()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u521b\u5efa\u65b0\u4f53\u7cfb\u3010%1$s\u3011\u5931\u8d25\uff0c\u5bfc\u5165\u6587\u4ef6\u4e2d\u4f53\u7cfb\u7684\u9002\u7528\u7f16\u62a5\u7c7b\u578b\u65e0\u53ef\u7528\u72b6\u6001\u7684\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BodySysImportHandlerImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]), this.bodySysImportInfo.getBodySysName()));
        }
        return false;
    }

    @Override
    public String getHandleEntity() {
        return "fpm_bodysysmanage";
    }

    @Override
    protected boolean abort() {
        return true;
    }
}

