/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;
import kd.tmc.fpm.business.service.fundsys.exportandimport.mapper.DynamicObjectMapper;
import kd.tmc.fpm.business.service.fundsys.exportandimport.period.PeriodMemTree;
import kd.tmc.fpm.business.service.fundsys.exportandimport.period.PeriodParamInfo;
import kd.tmc.fpm.common.enums.OrgReportTypeCycleEnum;
import kd.tmc.fpm.common.enums.OrgReportTypeEnum;
import kd.tmc.fpm.common.enums.WeekEnum;
import org.apache.commons.lang3.tuple.Pair;

public class DimensionImportHandlerImpl
extends AbstractBodySystemImportHandler {
    private DynamicObjectMapper dynamicObjectMapper;
    private static final Log logger = LogFactory.getLog(DimensionImportHandlerImpl.class);

    public DimensionImportHandlerImpl(BodySysImportContext bodySysImportContext) {
        super(bodySysImportContext);
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject originalDy) {
        this.register(this.getId(originalDy), clone);
        this.setOrCleanBaseData(clone);
        this.resetProp(clone);
    }

    private void setOrCleanBaseData(DynamicObject clone) {
        DynamicObject relBaseData = clone.getDynamicObject("relbasedata");
        if (EmptyUtil.isNoEmpty((DynamicObject)relBaseData)) {
            try {
                String entityName = relBaseData.getPkValue().toString();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
                if (Objects.isNull(dataEntityType)) {
                    clone.set("basedata", (Object)DimensionType.CUSTOM.getNumber());
                    clone.set("relbasedata", null);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                clone.set("basedata", (Object)DimensionType.CUSTOM.getNumber());
                clone.set("relbasedata", null);
            }
        }
    }

    @Override
    public String getHandleEntity() {
        return "fpm_dimension";
    }

    @Override
    protected boolean skip(DynamicObject dynamicObject) {
        String dimensionNumber = dynamicObject.getString("basedata");
        DimensionType dimensionType = DimensionType.getDimsionByNumber(dimensionNumber);
        DynamicObject bodySystem = dynamicObject.getDynamicObject("bodysystem");
        if (Objects.isNull((Object)dimensionType)) {
            logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u7ef4\u5ea6\uff1a{}\u7684\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u7a7a\uff0c\u4e0d\u5bfc\u5165", (Object)bodySystem.getString("name"), (Object)dynamicObject.getString("name"));
            return true;
        }
        if (dimensionType.isMetric()) {
            logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u5ea6\u91cf\u503c\uff1a{}\u4e0d\u5bfc\u5165\u3002", (Object)bodySystem.getString("name"), (Object)dynamicObject.getString("name"));
            return true;
        }
        if (!dimensionType.isSystemDim()) {
            logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u7ef4\u5ea6\uff1a{}\u4e0d\u662f\u7cfb\u7edf\u7ef4\u5ea6\uff0c\u4e0d\u8df3\u8fc7\u5bfc\u5165\u3002", (Object)bodySystem.getString("name"), (Object)dynamicObject.getString("name"));
            return super.skip(dynamicObject);
        }
        if (dimensionType.isPeriodDim()) {
            this.generateCurrentYear(dynamicObject);
        }
        return true;
    }

    private void generateCurrentYear(DynamicObject dynamicObject) {
        DynamicObject bodySystem = dynamicObject.getDynamicObject("bodysystem");
        Long systemOldId = this.getId(bodySystem);
        Long newSystemId = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getId(systemOldId);
        DynamicObjectCollection dynamicObjectCollection = bodySystem.getDynamicObjectCollection("applyrereportentry");
        List reportTypeList = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("rerporttype")).collect(Collectors.toList());
        Long oldDimensionId = this.getId(dynamicObject);
        Long newDimensionId = this.getIdPool().getId(oldDimensionId);
        for (DynamicObject reportType : reportTypeList) {
            Long oldReportTypeId = this.getId(reportType);
            DynamicObject reportTypeNewDy = this.bodySystemImportIdPool.getIdPool("fpm_orgreporttype").getDynamicObjectByOldId(oldReportTypeId);
            this.doGenerateCurrentYear(reportTypeNewDy, newSystemId, newDimensionId);
        }
    }

    private void doGenerateCurrentYear(DynamicObject reportType, Long systemId, Long dimensionId) {
        String reportCycle = reportType.getString("orgreportcycle");
        String orgReportType = reportType.getString("orgreporttype");
        String weekType = "month";
        PeriodParamInfo paramInfo = new PeriodParamInfo();
        if (OrgReportTypeCycleEnum.YEAR.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                paramInfo.setHasYear(true);
            } else if (OrgReportTypeEnum.HALFYEAR.getValue().equals(orgReportType)) {
                paramInfo.setHasHalfYear(true);
                paramInfo.setYearInHYear(true);
            } else if (OrgReportTypeEnum.QUARTER.getValue().equals(orgReportType)) {
                paramInfo.setHasQuarter(true);
                paramInfo.setYearInQuarter(true);
            } else if (OrgReportTypeEnum.MONTH.getValue().equals(orgReportType)) {
                paramInfo.setHasMonth(true);
                paramInfo.setYearInMonth(true);
            }
        }
        if (OrgReportTypeCycleEnum.HALFYEAR.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                paramInfo.setHasHalfYear(true);
            } else if (OrgReportTypeEnum.QUARTER.getValue().equals(orgReportType)) {
                paramInfo.setHasQuarter(true);
                paramInfo.setHalfYearInQuarter(true);
            } else if (OrgReportTypeEnum.MONTH.getValue().equals(orgReportType)) {
                paramInfo.setHasMonth(true);
                paramInfo.setHalfyearinMonth(true);
            }
        }
        if (OrgReportTypeCycleEnum.QUARTER.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                paramInfo.setHasQuarter(true);
            } else if (OrgReportTypeEnum.MONTH.getValue().equals(orgReportType)) {
                paramInfo.setHasMonth(true);
                paramInfo.setQuarterinMonth(true);
            }
        }
        if (OrgReportTypeCycleEnum.MONTH.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                paramInfo.setHasMonth(true);
            } else if (OrgReportTypeEnum.DAY.getValue().equals(orgReportType)) {
                paramInfo.setHasDay(true);
                paramInfo.setMonthInDay(true);
            } else if (OrgReportTypeEnum.WEEK.getValue().equals(orgReportType)) {
                if (weekType.equals("year")) {
                    paramInfo.setHasYearWeek(true);
                } else {
                    paramInfo.setHasMonthWeek(true);
                    paramInfo.setMonthInMonthWeek(true);
                }
            } else if (OrgReportTypeEnum.TEN.getValue().equals(orgReportType)) {
                paramInfo.setMonthInTenday(true);
                paramInfo.setHastenDay(true);
            }
        }
        if (OrgReportTypeCycleEnum.TEN.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                paramInfo.setHastenDay(true);
            } else if (OrgReportTypeEnum.DAY.getValue().equals(orgReportType)) {
                paramInfo.setHasDay(true);
                paramInfo.setTenDayInDay(true);
            }
        }
        if (OrgReportTypeCycleEnum.WEEK.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                if (weekType.equals("year")) {
                    paramInfo.setHasYearWeek(true);
                } else {
                    paramInfo.setHasMonthWeek(true);
                }
            } else if (OrgReportTypeEnum.DAY.getValue().equals(orgReportType)) {
                paramInfo.setHasDay(true);
                if (weekType.equals("year")) {
                    paramInfo.setYearWeekInDay(true);
                } else {
                    paramInfo.setMonthWeekInDay(true);
                }
            }
        }
        if (OrgReportTypeCycleEnum.DAY.getValue().equals(reportCycle)) {
            paramInfo.setHasDay(true);
        }
        WeekEnum startNode = WeekEnum.Monday;
        paramInfo.setStartNode(startNode);
        paramInfo.setModel(systemId.toString());
        paramInfo.setReportType(reportType.getLong("id"));
        PeriodMemTree periodTree = new PeriodMemTree(paramInfo);
        periodTree.setDimension(dimensionId);
        Pair<String, String> createInfo = periodTree.createTree(DateUtils.getYear((Date)new Date()), 1);
        String successYear = (String)createInfo.getLeft();
        String errorYear = (String)createInfo.getRight();
        if (EmptyUtil.isNoEmpty((String)successYear) && EmptyUtil.isEmpty((String)errorYear)) {
            logger.info("{} \u671f\u95f4\u6210\u5458\u65b0\u589e\u6210\u529f", (Object)successYear);
        }
        if (EmptyUtil.isNoEmpty((String)successYear) && EmptyUtil.isNoEmpty((String)errorYear)) {
            logger.warn("{} \u671f\u95f4\u6210\u5458\u65b0\u589e\u6210\u529f\uff1b\u4e14\u8df3\u8fc7\u5df2\u5b58\u5728\u7684\u8d22\u5e74{}", (Object)successYear, (Object)errorYear);
        }
        if (EmptyUtil.isEmpty((String)successYear) && EmptyUtil.isNoEmpty((String)errorYear)) {
            logger.warn("\u8df3\u8fc7\u5df2\u5b58\u5728\u7684\u8d22\u5e74%s", (Object)errorYear);
        }
    }

    @Override
    protected void beforeHandler(List<DynamicObject> dynamicObjectList) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return;
        }
        DynamicObject dynamicObject = dynamicObjectList.get(0);
        DynamicObject bodySystem = dynamicObject.getDynamicObject("bodysystem");
        Long systemOldId = this.getId(bodySystem);
        Long newSystemId = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getId(systemOldId);
        if (Objects.isNull(this.dynamicObjectMapper)) {
            this.dynamicObjectMapper = new DynamicObjectMapper(dy -> dy.getString("number"));
            this.dynamicObjectMapper.init("fpm_dimension", new QFilter("bodysystem", "=", (Object)newSystemId));
        }
        for (DynamicObject dy2 : dynamicObjectList) {
            String baseData = dy2.getString("basedata");
            DimensionType dimensionType = DimensionType.getDimsionByNumber(baseData);
            if (dimensionType == null || !dimensionType.isSystemDim()) continue;
            String number = dy2.getString("number");
            DynamicObjectMapper.MapperObjectHolder mapperObjectHolder = this.dynamicObjectMapper.getMapperObjectHolder(number);
            this.getIdPool().registerNewIdExists(this.getId(dy2), mapperObjectHolder.getDynamicObject());
        }
    }
}

