/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;
import kd.tmc.fpm.business.service.fundsys.exportandimport.mapper.DynamicObjectMapper;

public class DimensionMemberImportHandlerImpl
extends AbstractBodySystemImportHandler {
    private DynamicObjectMapper dynamicObjectMapper;

    public DimensionMemberImportHandlerImpl(BodySysImportContext bodySysImportContext) {
        super(bodySysImportContext);
    }

    @Override
    public String getHandleEntity() {
        return "fpm_member";
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject originalDy) {
        this.register(this.getId(originalDy), clone);
        this.setOrCleanBaseData(clone);
        this.resetProp(clone);
    }

    private void setOrCleanBaseData(DynamicObject clone) {
        String dimType = clone.getString("dimtype");
        if (Objects.equals(dimType, DimensionType.CURRENCY.getNumber())) {
            String currencyNumber = clone.getString("number");
            DynamicObjectMapper.MapperObjectHolder mapperObjectHolder = this.dynamicObjectMapper.getMapperObjectHolder(currencyNumber);
            clone.set("sourceid", (Object)mapperObjectHolder.getId());
        } else {
            clone.set("sourceid", (Object)0L);
        }
    }

    @Override
    protected void beforeHandler(List<DynamicObject> dynamicObjectList) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return;
        }
        List currencyDimList = dynamicObjectList.stream().filter(dy -> Objects.equals(dy.getString("dimtype"), DimensionType.CURRENCY.getNumber())).collect(Collectors.toList());
        List currencyNumberList = currencyDimList.stream().map(dy -> dy.getString("number")).collect(Collectors.toList());
        this.dynamicObjectMapper = new DynamicObjectMapper(dy -> dy.getString("number"));
        this.dynamicObjectMapper.init("bd_currency", new QFilter("number", "in", currencyNumberList));
    }

    @Override
    protected boolean skip(DynamicObject dynamicObject) {
        String dimType = dynamicObject.getString("dimtype");
        DimensionType dimensionType = DimensionType.getDimsionByNumber(dimType);
        if (Objects.isNull((Object)dimensionType)) {
            return true;
        }
        if (dimensionType.isOrgDim() || dimensionType.isPeriodDim()) {
            return true;
        }
        if (dimensionType.isMetric()) {
            return true;
        }
        if (dimensionType.isCurrencyDim()) {
            String currencyNumber = dynamicObject.getString("number");
            DynamicObjectMapper.MapperObjectHolder mapperObjectHolder = this.dynamicObjectMapper.getMapperObjectHolder(currencyNumber);
            if (Objects.isNull(mapperObjectHolder)) {
                return true;
            }
            long oldSystemId = dynamicObject.getDynamicObject("bodysystem").getLong("id");
            DynamicObject systemDy = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getDynamicObjectByOldId(oldSystemId);
            DynamicObject currencyDy = systemDy.getDynamicObject("currency");
            return Objects.equals(mapperObjectHolder.getMapperKey(), currencyDy.getString("number"));
        }
        return false;
    }

    @Override
    protected void afterHandler(List<DynamicObject> dynamicObjectList) {
        super.afterHandler(dynamicObjectList);
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return;
        }
        long oldSystemId = dynamicObjectList.get(0).getDynamicObject("bodysystem").getLong("id");
        DynamicObject systemDy = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getDynamicObjectByOldId(oldSystemId);
        DynamicObject currencyDy = systemDy.getDynamicObject("currency");
        QFilter qFilter = new QFilter("dimtype", "=", (Object)DimensionType.CURRENCY.getNumber()).and(new QFilter("bodysystem", "=", (Object)this.getId(systemDy))).and(new QFilter("number", "=", (Object)currencyDy.getString("number"))).and(new QFilter("sourceid", "=", (Object)currencyDy.getLong("id")));
        List list = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])new QFilter[]{qFilter}, null, (int)1);
        if (EmptyUtil.isEmpty((Collection)list)) {
            return;
        }
        DynamicObject currencyDimMemberDy = TmcDataServiceHelper.loadSingle(list.get(0), (String)"fpm_member");
        for (DynamicObject dynamicObject : dynamicObjectList) {
            String key;
            if (!Objects.equals(dynamicObject.getString("dimtype"), DimensionType.CURRENCY.getNumber()) || !Objects.equals(key = dynamicObject.getString("number"), currencyDy.getString("number"))) continue;
            this.getIdPool().registerNewIdExists(this.getId(dynamicObject), currencyDimMemberDy);
        }
    }
}

