/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;
import kd.tmc.fpm.common.bean.SubjectCancelConfig;
import org.apache.commons.lang3.StringUtils;

public class InnerCancelRuleImportHandlerImpl
extends AbstractBodySystemImportHandler {
    public InnerCancelRuleImportHandlerImpl(BodySysImportContext bodySysImportContext) {
        super(bodySysImportContext);
    }

    @Override
    public String getHandleEntity() {
        return "fpm_internalcancelrule";
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject originalDy) {
        this.registerAndResetNumber(this.getId(originalDy), clone);
        this.removeCurrencyIfNotExists(clone);
        this.clearApplyOrgEntry(clone);
        this.resetProp(clone);
    }

    private void clearApplyOrgEntry(DynamicObject clone) {
        DynamicObjectCollection dynamicObjectCollection = clone.getDynamicObjectCollection("apply_entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return;
        }
        dynamicObjectCollection.clear();
    }

    @Override
    protected void doReset(DynamicObject restDy, IDataEntityProperty dataEntityProperty) {
        super.doReset(restDy, dataEntityProperty);
        if (!Objects.equals("entry_inconfigreal_tag", dataEntityProperty.getName()) && !Objects.equals("entry_outconfigreal_tag", dataEntityProperty.getName())) {
            return;
        }
        String configJson = restDy.getString(dataEntityProperty);
        if (StringUtils.isEmpty((CharSequence)configJson)) {
            return;
        }
        SubjectCancelConfig subjectCancelConfig = (SubjectCancelConfig)SerializationUtils.fromJsonString((String)configJson, SubjectCancelConfig.class);
        subjectCancelConfig.setBodySysId(this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getId(subjectCancelConfig.getBodySysId()));
        List subjectList = subjectCancelConfig.getSubjectList();
        for (SubjectCancelConfig.Subject subject : subjectList) {
            subject.setParentId(this.bodySystemImportIdPool.getIdPool("fpm_membersubject").getId(subject.getParentId()));
            subject.setId(this.bodySystemImportIdPool.getIdPool("fpm_membersubject").getId(subject.getId()));
        }
        dataEntityProperty.setValueFast((Object)restDy, (Object)SerializationUtils.toJsonString((Object)subjectCancelConfig));
    }

    private void removeCurrencyIfNotExists(DynamicObject clone) {
        DynamicObjectCollection dynamicObjectCollection = clone.getDynamicObjectCollection("applycurrency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            dynamicObjectCollection.removeIf(dy -> EmptyUtil.isEmpty((Long)this.bodySystemImportIdPool.getIdPool("fpm_member").getId(this.getId(dy.getDynamicObject("fbasedataid")))));
        }
    }
}

