/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRuleDimension;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRuleDimensionMember;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;

public class ReportCheckRuleImportHandlerImpl
extends AbstractBodySystemImportHandler {
    public ReportCheckRuleImportHandlerImpl(BodySysImportContext bodySysImportContext) {
        super(bodySysImportContext);
    }

    @Override
    public String getHandleEntity() {
        return "fpm_reportcheckrule";
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject originalDy) {
        this.registerAndResetNumber(this.getId(originalDy), clone);
        this.resetMemberScopeIfNeed(clone);
        this.resetProp(clone);
    }

    @Override
    protected void doReset(DynamicObject restDy, IDataEntityProperty dataEntityProperty) {
        super.doReset(restDy, dataEntityProperty);
        if (!Objects.equals(dataEntityProperty.getName(), "checkeddimensionvalue_tag") && !Objects.equals(dataEntityProperty.getName(), "checkdimensionvalue_tag")) {
            return;
        }
        String jsonString = restDy.getString(dataEntityProperty);
        if (EmptyUtil.isEmpty((String)jsonString)) {
            return;
        }
        List reportVerifyRuleDimensionList = SerializationUtils.fromJsonStringToList((String)jsonString, ReportVerifyRuleDimension.class);
        if (Objects.isNull(reportVerifyRuleDimensionList)) {
            return;
        }
        for (ReportVerifyRuleDimension reportVerifyRuleDimension : reportVerifyRuleDimensionList) {
            reportVerifyRuleDimension.setDimensionId(this.bodySystemImportIdPool.getIdPool("fpm_dimension").getId(reportVerifyRuleDimension.getDimensionId()));
            List<ReportVerifyRuleDimensionMember> memberParams = reportVerifyRuleDimension.getMemberParams();
            if (!EmptyUtil.isNoEmpty(memberParams)) continue;
            for (ReportVerifyRuleDimensionMember member : memberParams) {
                member.setDimensionMemberId(this.bodySystemImportIdPool.getIdPool("fpm_member").getId(member.getDimensionMemberId()));
                member.setDimensionId(this.bodySystemImportIdPool.getIdPool("fpm_dimension").getId(member.getDimensionId()));
            }
        }
        dataEntityProperty.setValueFast((Object)restDy, (Object)SerializationUtils.toJsonString((Object)reportVerifyRuleDimensionList));
    }

    private void resetMemberScopeIfNeed(DynamicObject clone) {
        DynamicObjectCollection dynamicObjectCollection = clone.getDynamicObjectCollection("entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return;
        }
        Long oldSystemId = this.getId(clone.getDynamicObject("bodysysmanage"));
        Long newSystemId = this.bodySystemImportIdPool.getIdPool("fpm_bodysysmanage").getId(oldSystemId);
        Long dutyOrgMemberId = this.bodySysImportContext.getDutyOrgMemberId(newSystemId);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObjectCollection dc = dynamicObject.getDynamicObjectCollection("mulmembers");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)dc)) continue;
            DynamicObject dimensionDy = dynamicObject.getDynamicObject("dimension");
            String number = dimensionDy.getString("number");
            if (Objects.equals(number, DimensionType.CURRENCY.getNumber())) {
                dc.removeIf(dy -> EmptyUtil.isEmpty((Long)this.bodySystemImportIdPool.getIdPool("fpm_member").getId(this.getId(dy.getDynamicObject("fbasedataid")))));
                continue;
            }
            if (!Objects.equals(number, DimensionType.ORG.getNumber())) continue;
            DynamicObject memberDy = (DynamicObject)dc.get(0);
            dc.removeIf(dy -> !Objects.equals(dy, memberDy));
            DynamicObject dutyOrgMember = this.bodySystemImportIdPool.getIdPool("fpm_member").getDynamicObject(dutyOrgMemberId);
            memberDy.set("fbasedataid", (Object)dutyOrgMember);
            memberDy.set("fbasedataid_id", (Object)this.getId(dutyOrgMember));
        }
    }
}

